/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalizationStatus;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LocalizationStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.SerializedExceptionPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetLocalizationStatusesResponsePBImpl
extends GetLocalizationStatusesResponse {
    private YarnServiceProtos.GetLocalizationStatusesResponseProto proto = YarnServiceProtos.GetLocalizationStatusesResponseProto.getDefaultInstance();
    private YarnServiceProtos.GetLocalizationStatusesResponseProto.Builder builder;
    private boolean viaProto = false;
    private Map<ContainerId, List<LocalizationStatus>> localizationStatuses;
    private Map<ContainerId, SerializedException> failedRequests;

    public GetLocalizationStatusesResponsePBImpl() {
        this.builder = YarnServiceProtos.GetLocalizationStatusesResponseProto.newBuilder();
    }

    public GetLocalizationStatusesResponsePBImpl(YarnServiceProtos.GetLocalizationStatusesResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.GetLocalizationStatusesResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetLocalizationStatusesResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.localizationStatuses != null) {
            this.addLocalStatusesToProto();
        }
        if (this.failedRequests != null) {
            this.addFailedRequestsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetLocalizationStatusesResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addLocalStatusesToProto() {
        this.maybeInitBuilder();
        this.builder.clearCntnLocalizationStatuses();
        if (this.localizationStatuses == null) {
            return;
        }
        ArrayList protos = new ArrayList();
        this.localizationStatuses.forEach((containerId, statuses) -> {
            if (statuses != null && !statuses.isEmpty()) {
                YarnServiceProtos.ContainerLocalizationStatusesProto.Builder clProtoBuilder = YarnServiceProtos.ContainerLocalizationStatusesProto.newBuilder();
                statuses.forEach(status -> clProtoBuilder.addLocalizationStatuses(this.convertToProtoFormat((LocalizationStatus)status)));
                clProtoBuilder.setContainerId(this.convertToProtoFormat((ContainerId)containerId));
                protos.add(clProtoBuilder.build());
            }
        });
        this.builder.addAllCntnLocalizationStatuses(protos);
    }

    private void addFailedRequestsToProto() {
        this.maybeInitBuilder();
        this.builder.clearFailedRequests();
        if (this.failedRequests == null) {
            return;
        }
        ArrayList<YarnServiceProtos.ContainerExceptionMapProto> protoList = new ArrayList<YarnServiceProtos.ContainerExceptionMapProto>();
        for (Map.Entry<ContainerId, SerializedException> entry : this.failedRequests.entrySet()) {
            protoList.add(YarnServiceProtos.ContainerExceptionMapProto.newBuilder().setContainerId(this.convertToProtoFormat(entry.getKey())).setException(this.convertToProtoFormat(entry.getValue())).build());
        }
        this.builder.addAllFailedRequests(protoList);
    }

    private void initLocalContainerStatuses() {
        if (this.localizationStatuses != null) {
            return;
        }
        YarnServiceProtos.GetLocalizationStatusesResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServiceProtos.ContainerLocalizationStatusesProto> protoList = p.getCntnLocalizationStatusesList();
        this.localizationStatuses = new HashMap<ContainerId, List<LocalizationStatus>>();
        for (YarnServiceProtos.ContainerLocalizationStatusesProto clProto : protoList) {
            List<YarnServiceProtos.LocalizationStatusProto> lsProtos = clProto.getLocalizationStatusesList();
            ArrayList statusesPerCntn = new ArrayList();
            lsProtos.forEach(lsProto -> statusesPerCntn.add(this.convertFromProtoFormat((YarnServiceProtos.LocalizationStatusProto)lsProto)));
            this.localizationStatuses.put(this.convertFromProtoFormat(clProto.getContainerId()), statusesPerCntn);
        }
    }

    private void initFailedRequests() {
        if (this.failedRequests != null) {
            return;
        }
        YarnServiceProtos.GetLocalizationStatusesResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServiceProtos.ContainerExceptionMapProto> protoList = p.getFailedRequestsList();
        this.failedRequests = new HashMap<ContainerId, SerializedException>();
        for (YarnServiceProtos.ContainerExceptionMapProto ce : protoList) {
            this.failedRequests.put(this.convertFromProtoFormat(ce.getContainerId()), this.convertFromProtoFormat(ce.getException()));
        }
    }

    @Override
    public Map<ContainerId, List<LocalizationStatus>> getLocalizationStatuses() {
        this.initLocalContainerStatuses();
        return this.localizationStatuses;
    }

    @Override
    public void setLocalizationStatuses(Map<ContainerId, List<LocalizationStatus>> statuses) {
        this.maybeInitBuilder();
        if (statuses == null) {
            this.builder.clearCntnLocalizationStatuses();
        }
        this.localizationStatuses = statuses;
    }

    @Override
    public Map<ContainerId, SerializedException> getFailedRequests() {
        this.initFailedRequests();
        return this.failedRequests;
    }

    @Override
    public void setFailedRequests(Map<ContainerId, SerializedException> failedRequests) {
        this.maybeInitBuilder();
        if (failedRequests == null) {
            this.builder.clearFailedRequests();
        }
        this.failedRequests = failedRequests;
    }

    private LocalizationStatusPBImpl convertFromProtoFormat(YarnServiceProtos.LocalizationStatusProto p) {
        return new LocalizationStatusPBImpl(p);
    }

    private YarnServiceProtos.LocalizationStatusProto convertToProtoFormat(LocalizationStatus t) {
        return ((LocalizationStatusPBImpl)t).getProto();
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private SerializedExceptionPBImpl convertFromProtoFormat(YarnProtos.SerializedExceptionProto p) {
        return new SerializedExceptionPBImpl(p);
    }

    private YarnProtos.SerializedExceptionProto convertToProtoFormat(SerializedException t) {
        return ((SerializedExceptionPBImpl)t).getProto();
    }
}

