/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.transport;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.TransportSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.util.SandeshaUtil;

public class Sandesha2TransportSender
implements TransportSender {
    private static final Log log = LogFactory.getLog(Sandesha2TransportSender.class);

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void stop() {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        TransportOutDescription transportOut;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: Sandesha2TransportSender::invoke, " + msgContext.getEnvelope().getHeader()));
        }
        if ((transportOut = (TransportOutDescription)msgContext.getProperty("Sandesha2OriginalTransportSender")) == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("transportOutNotPresent"));
        }
        msgContext.setTransportOut(transportOut);
        String key = (String)msgContext.getProperty("Sandesha2MessageStoreKey");
        if (key == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotGetStorageKey"));
        }
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, (AxisDescription)axisConfiguration);
        msgContext.setProperty("Sandesha2QualifiedForSending", (Object)"true");
        storageManager.storeMessageContext(key, msgContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: Sandesha2TransportSender::invoke");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void cleanUp(MessageContext msgContext) throws AxisFault {
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void cleanup() {
    }

    public HandlerDescription getHandlerDesc() {
        return null;
    }

    public String getName() {
        return null;
    }

    public Parameter getParameter(String name) {
        return null;
    }

    public void init(HandlerDescription handlerdesc) {
    }

    public void flowComplete(MessageContext msgContext) {
    }
}

