/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.BaseConfigurationXMLReader;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TestBaseConfigurationXMLReader {
    private static final String[] CONTINENTS = new String[]{"Africa", "America", "Asia", "Australia", "Europe"};
    private BaseConfiguration config;
    private BaseConfigurationXMLReader configReader;

    @Before
    public void setUp() throws Exception {
        this.config = new BaseConfiguration();
        this.config.addProperty("world.continents.continent", Arrays.asList(CONTINENTS));
        this.config.addProperty("world.greeting", (Object)"Hello");
        this.config.addProperty("world.greeting", (Object)"Salute");
        this.config.addProperty("world.wish", (Object)"Peace");
        this.config.addProperty("application.mail.smtp", (Object)"smtp.mymail.org");
        this.config.addProperty("application.mail.pop", (Object)"pop3.mymail.org");
        this.config.addProperty("application.mail.account.type", (Object)"pop3");
        this.config.addProperty("application.mail.account.user", (Object)"postmaster");
        this.config.addProperty("application.mail.account.pwd", (Object)"?.-gulp*#");
        this.config.addProperty("application.mail.timeout", (Object)new Integer(42));
        this.config.addProperty("test", (Object)Boolean.TRUE);
        this.configReader = new BaseConfigurationXMLReader((Configuration)this.config);
    }

    @Test
    public void testParse() throws Exception {
        this.checkDocument(this.configReader, "config");
    }

    @Test(expected=SAXException.class)
    public void testParseSAXException() throws IOException, SAXException {
        this.configReader.setContentHandler((ContentHandler)new TestContentHandler());
        this.configReader.parse("systemID");
    }

    @Test(expected=IOException.class)
    public void testParseIOException() throws SAXException, IOException {
        BaseConfigurationXMLReader reader = new BaseConfigurationXMLReader();
        reader.parse("document");
    }

    @Test
    public void testSetRootName() throws Exception {
        BaseConfigurationXMLReader reader = new BaseConfigurationXMLReader((Configuration)this.config);
        reader.setRootName("apache");
        this.checkDocument(reader, "apache");
    }

    private void checkDocument(BaseConfigurationXMLReader creader, String rootName) throws Exception {
        SAXSource source = new SAXSource((XMLReader)creader, new InputSource());
        DOMResult result = new DOMResult();
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.transform(source, result);
        Element root = ((Document)result.getNode()).getDocumentElement();
        JXPathContext ctx = JXPathContext.newContext((Object)root);
        Assert.assertEquals((String)"Wrong root name", (Object)rootName, (Object)root.getNodeName());
        Assert.assertEquals((String)"Wrong number of children", (long)3L, (long)ctx.selectNodes("/*").size());
        this.check(ctx, "world/continents/continent", CONTINENTS);
        this.check(ctx, "world/greeting", new String[]{"Hello", "Salute"});
        this.check(ctx, "world/wish", "Peace");
        this.check(ctx, "application/mail/smtp", "smtp.mymail.org");
        this.check(ctx, "application/mail/timeout", "42");
        this.check(ctx, "application/mail/account/type", "pop3");
        this.check(ctx, "application/mail/account/user", "postmaster");
        this.check(ctx, "test", "true");
    }

    private void check(JXPathContext ctx, String path, String[] values) {
        Iterator it = ctx.iterate(path);
        for (int i = 0; i < values.length; ++i) {
            Assert.assertTrue((String)"Too few values", (boolean)it.hasNext());
            Assert.assertEquals((String)"Wrong property value", (Object)values[i], it.next());
        }
        Assert.assertFalse((String)"Too many values", (boolean)it.hasNext());
    }

    private void check(JXPathContext ctx, String path, String value) {
        this.check(ctx, path, new String[]{value});
    }

    private static class TestContentHandler
    extends DefaultHandler {
        private TestContentHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            throw new SAXException("Test exception during parsing");
        }
    }
}

