/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.plexus.MatchPatterns;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;

public interface MatcherSet {
    public Optional<DocumentNameMatcher> includes();

    public Optional<DocumentNameMatcher> excludes();

    default public String getDescription() {
        return String.format("MatcherSet: include [%s] exclude [%s]", this.includes().orElse(DocumentNameMatcher.MATCHES_NONE), this.excludes().orElse(DocumentNameMatcher.MATCHES_NONE));
    }

    default public DocumentNameMatcher createMatcher() {
        return DocumentNameMatcher.matcherSet(this.includes().orElse(DocumentNameMatcher.MATCHES_NONE), this.excludes().orElse(DocumentNameMatcher.MATCHES_NONE));
    }

    public static MatcherSet merge(List<MatcherSet> matcherSets) {
        Builder builder = new Builder();
        for (MatcherSet matcherSet : matcherSets) {
            matcherSet.includes().ifPresent(builder::addIncluded);
            matcherSet.excludes().ifPresent(builder::addExcluded);
        }
        return builder.build();
    }

    public static class Builder {
        protected DocumentNameMatcher included;
        protected DocumentNameMatcher excluded;

        public static void segregateList(Set<String> matching, Set<String> notMatching, Iterable<String> patterns) {
            patterns.forEach(s -> {
                if (ExclusionUtils.MATCH_FILTER.test((String)s)) {
                    matching.add((String)s);
                } else {
                    notMatching.add(s.substring(1));
                }
            });
        }

        private void processNames(Consumer<DocumentNameMatcher> dest, String nameFormat, DocumentName fromDocument, Set<String> names) {
            if (!names.isEmpty()) {
                String name = String.format(nameFormat, fromDocument.localized("/").substring(1));
                dest.accept(new DocumentNameMatcher(name, MatchPatterns.from(fromDocument.getDirectorySeparator(), names), fromDocument.getBaseDocumentName()));
            }
        }

        public Builder addIncluded(DocumentName fromDocument, Set<String> names) {
            this.processNames(this::addIncluded, "'included %s'", fromDocument, names);
            return this;
        }

        public Builder addExcluded(DocumentName fromDocument, Set<String> names) {
            this.processNames(this::addExcluded, "'excluded %s'", fromDocument, names);
            return this;
        }

        public Builder addIncluded(DocumentNameMatcher matcher) {
            this.included = this.included == null ? matcher : DocumentNameMatcher.or(this.included, matcher);
            return this;
        }

        public Builder addExcluded(DocumentNameMatcher matcher) {
            this.excluded = this.excluded == null ? matcher : DocumentNameMatcher.or(this.excluded, matcher);
            return this;
        }

        public MatcherSet build() {
            MatcherSet result = new MatcherSet(){
                private final DocumentNameMatcher myIncluded;
                private final DocumentNameMatcher myExcluded;
                {
                    this.myIncluded = included;
                    this.myExcluded = excluded;
                }

                @Override
                public Optional<DocumentNameMatcher> includes() {
                    return Optional.ofNullable(this.myIncluded);
                }

                @Override
                public Optional<DocumentNameMatcher> excludes() {
                    return Optional.ofNullable(this.myExcluded);
                }
            };
            this.included = null;
            this.excluded = null;
            return result;
        }
    }
}

