/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public class PemConfigUtil {
    public static final String PEMCFG_STORE_TYPE = "PEMCFG";
    public static final String SOURCE_PREFIX = "source.";

    public static boolean isPemConfigStoreType(String storeType) {
        return PEMCFG_STORE_TYPE.equals(storeType);
    }

    public static String[] parseSources(InputStream stream) throws IOException {
        ArrayList<String> sources = new ArrayList<String>();
        Properties pemConfigProperties = new Properties();
        pemConfigProperties.load(stream);
        for (String key : pemConfigProperties.stringPropertyNames()) {
            String source;
            if (!key.startsWith(SOURCE_PREFIX) || (source = pemConfigProperties.getProperty(key)) == null) continue;
            sources.add(source);
        }
        return sources.toArray(new String[sources.size()]);
    }
}

