/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.quantilescommon.LongsSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesLongsSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllLongsSketchIteratorTest {
    @Test
    public void emptySketch() {
        KllLongsSketch sketch = KllLongsSketch.newHeapInstance();
        QuantilesLongsSketchIterator it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        KllLongsSketch sketch = KllLongsSketch.newHeapInstance();
        sketch.update(1L);
        QuantilesLongsSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((long)it.getQuantile(), (long)1L);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void twoItemSketchForIterator() {
        KllLongsSketch sketch = KllLongsSketch.newHeapInstance();
        sketch.update(1L);
        sketch.update(2L);
        QuantilesLongsSketchIterator itr = sketch.iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((long)itr.getQuantile(), (long)2L);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((long)itr.getQuantile(), (long)1L);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
    }

    @Test
    public void twoItemSketchForSortedViewIterator() {
        KllLongsSketch sketch = KllLongsSketch.newHeapInstance();
        sketch.update(1L);
        sketch.update(2L);
        LongsSortedViewIterator itr = sketch.getSortedView().iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((long)itr.getQuantile(), (long)1L);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)0.5);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((long)itr.getQuantile(), (long)2L);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.5);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)1.0);
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            KllLongsSketch sketch = KllLongsSketch.newHeapInstance();
            for (int i = 0; i < n; ++i) {
                sketch.update((long)i);
            }
            QuantilesLongsSketchIterator it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }
}

