/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDirectLongsSketch;
import org.apache.datasketches.kll.KllHeapLongsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllLongsHelper;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.LongsSketchSortedView;
import org.apache.datasketches.quantilescommon.LongsSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscLongsTest {
    private final MemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void checkSortedViewConstruction() {
        KllLongsSketch kll = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 20; ++i) {
            kll.update((long)i);
        }
        LongsSketchSortedView fsv = kll.getSortedView();
        long[] cumWeights = fsv.getCumulativeWeights();
        long[] values = fsv.getQuantiles();
        Assert.assertEquals((int)cumWeights.length, (int)20);
        Assert.assertEquals((int)values.length, (int)20);
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)cumWeights[i], (long)(i + 1));
            Assert.assertEquals((long)values[i], (long)(i + 1));
        }
    }

    @Test
    public void checkBounds() {
        KllLongsSketch kll = KllLongsSketch.newHeapInstance();
        for (int i = 0; i < 1000; ++i) {
            kll.update((long)i);
        }
        double eps = kll.getNormalizedRankError(false);
        long est = kll.getQuantile(0.5);
        long ub = kll.getQuantileUpperBound(0.5);
        long lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((long)ub, (long)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((long)lb, (long)kll.getQuantile(0.5 - eps));
        KllMiscLongsTest.println("Ext     : " + est);
        KllMiscLongsTest.println("UB      : " + ub);
        KllMiscLongsTest.println("LB      : " + lb);
        double rest = kll.getRank(est);
        double restUB = kll.getRankUpperBound(rest);
        double restLB = kll.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions1() {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(6L, (byte)3);
        KllLongsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions2() {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllLongsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions3() {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance();
        sk.update(1L);
        sk.update(2L);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllLongsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions4() {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(1L, (byte)0);
        KllLongsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions5() {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(2L, (byte)0);
        KllLongsSketch.heapify((Memory)wmem);
    }

    @Test
    public void checkMisc() {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)8);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        KllMiscLongsTest.println(sk.toString(true, true));
        for (int i = 0; i < 20; ++i) {
            sk.update((long)i);
        }
        KllMiscLongsTest.println(sk.toString(true, true));
        sk.toByteArray();
        long[] items = sk.getLongItemsArray();
        Assert.assertEquals((int)items.length, (int)16);
        int[] levels = sk.getLevelsArray(sk.sketchStructure);
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    @Test
    public void visualCheckToString() {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        int n = 21;
        for (int i = 1; i <= n; ++i) {
            sk.update((long)i);
        }
        KllMiscLongsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk.getMaxItem(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        KllLongsSketch sk2 = KllLongsSketch.newHeapInstance((int)20);
        n = 400;
        for (int i = 101; i <= n + 100; ++i) {
            sk2.update((long)i);
        }
        KllMiscLongsTest.println(Util.LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((long)sk2.getMinItem(), (long)101L);
        Assert.assertEquals((long)sk2.getMaxItem(), (long)500L);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)52);
        sk2.merge((KllSketch)sk);
        KllMiscLongsTest.println(Util.LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((long)sk2.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk2.getMaxItem(), (long)500L);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)56);
    }

    @Test
    public void viewHeapCompactions() {
        int k = 20;
        int n = 108;
        boolean withLevels = false;
        boolean withLevelsAndItems = true;
        int compaction = 0;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((long)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscLongsTest.println(Util.LS + "#<<< BEFORE COMPACTION # " + ++compaction + " >>>");
            KllMiscLongsTest.println(sk.toString(withLevels, withLevelsAndItems));
            sk.update((long)(++i));
            KllMiscLongsTest.println(Util.LS + "#<<< AFTER COMPACTION  # " + compaction + " >>>");
            KllMiscLongsTest.println(sk.toString(withLevels, withLevelsAndItems));
            Assert.assertEquals((long)sk.getLongItemsArray()[sk.levelsArr[0]], (long)i);
        }
        KllMiscLongsTest.println(Util.LS + "#<<< END STATE # >>>");
        KllMiscLongsTest.println(sk.toString(withLevels, withLevelsAndItems));
        KllMiscLongsTest.println("");
    }

    @Test
    public void viewDirectCompactions() {
        int k = 20;
        int n = 108;
        boolean withLevels = false;
        boolean withLevelsAndItems = true;
        int compaction = 0;
        int sizeBytes = KllSketch.getMaxSerializedSizeBytes((int)k, (long)n, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        WritableMemory wmem = WritableMemory.allocate((int)sizeBytes);
        KllLongsSketch sk = KllLongsSketch.newDirectInstance((int)k, (WritableMemory)wmem, (MemoryRequestServer)this.memReqSvr);
        for (int i = 1; i <= n; ++i) {
            sk.update((long)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscLongsTest.println(Util.LS + "#<<< BEFORE COMPACTION # " + ++compaction + " >>>");
            KllMiscLongsTest.println(sk.toString(withLevels, withLevelsAndItems));
            sk.update((long)(++i));
            KllMiscLongsTest.println(Util.LS + "#<<< AFTER COMPACTION  # " + compaction + " >>>");
            KllMiscLongsTest.println(sk.toString(withLevels, withLevelsAndItems));
            Assert.assertEquals((long)sk.getLongItemsArray()[sk.levelsArr[0]], (long)i);
        }
        KllMiscLongsTest.println(Util.LS + "#<<< END STATE # >>>");
        KllMiscLongsTest.println(sk.toString(withLevels, withLevelsAndItems));
        KllMiscLongsTest.println("");
    }

    @Test
    public void viewCompactionAndSortedView() {
        int n = 43;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= n; ++i) {
            sk.update((long)i);
        }
        KllMiscLongsTest.println(sk.toString(true, true));
        LongsSketchSortedView sv = sk.getSortedView();
        LongsSortedViewIterator itr = sv.iterator();
        KllMiscLongsTest.println("### SORTED VIEW");
        KllMiscLongsTest.printf("%6s %12s %12s" + Util.LS, "Idx", "Value", "Weight");
        int i = 0;
        while (itr.next()) {
            long v = itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscLongsTest.printf("%6d %12d %12d" + Util.LS, i, v, wt);
            ++i;
        }
        Assert.assertEquals((long)sv.getMinItem(), (long)1L);
        Assert.assertEquals((long)sv.getMaxItem(), (long)n);
    }

    @Test
    public void checkWeightedUpdates1() {
        int k = 20;
        int weight = 127;
        long item = 10L;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        KllMiscLongsTest.println(sk.toString(true, true));
        sk.update(item, (long)weight);
        KllMiscLongsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumRetained(), (int)7);
        Assert.assertEquals((long)sk.getN(), (long)weight);
        sk.update(item, (long)weight);
        KllMiscLongsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumRetained(), (int)14);
        Assert.assertEquals((long)sk.getN(), (long)254L);
    }

    @Test
    public void checkWeightedUpdates2() {
        int k = 20;
        int initial = 1000;
        int weight = 127;
        long item = 10L;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= initial; ++i) {
            sk.update((long)(i + 1000));
        }
        KllMiscLongsTest.println(sk.toString(true, true));
        sk.update(item, (long)weight);
        KllMiscLongsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumRetained(), (int)65);
        Assert.assertEquals((long)sk.getN(), (long)1127L);
        LongsSortedViewIterator itr = sk.getSortedView().iterator();
        KllMiscLongsTest.println("### SORTED VIEW");
        KllMiscLongsTest.printf("%12s %12s %12s" + Util.LS, "Value", "Weight", "NaturalRank");
        long cumWt = 0L;
        while (itr.next()) {
            long v = itr.getQuantile();
            long wt = itr.getWeight();
            long natRank = itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE);
            Assert.assertEquals((long)(cumWt += wt), (long)natRank);
            KllMiscLongsTest.printf("%12d %12d %12d" + Util.LS, v, wt, natRank);
        }
        Assert.assertEquals((long)cumWt, (long)sk.getN());
    }

    @Test
    public void checkCreateItemsArray() {
        long item = 10L;
        int weight = 108;
        long[] itemsArr = KllLongsHelper.createItemsArray((long)item, (long)weight);
        Assert.assertEquals((int)itemsArr.length, (int)4);
        for (int i = 0; i < itemsArr.length; ++i) {
            itemsArr[i] = item;
        }
        KllMiscLongsTest.outputItems(itemsArr);
    }

    private static void outputItems(long[] itemsArr) {
        String[] hdr2 = new String[]{"Index", "Value"};
        String hdr2fmt = "%6s %15s" + Util.LS;
        String d2fmt = "%6d %15d" + Util.LS;
        KllMiscLongsTest.println("ItemsArr");
        KllMiscLongsTest.printf(hdr2fmt, hdr2);
        for (int i = 0; i < itemsArr.length; ++i) {
            KllMiscLongsTest.printf(d2fmt, i, itemsArr[i]);
        }
        KllMiscLongsTest.println("");
    }

    @Test
    public void checkCreateLevelsArray() {
        int weight = 108;
        int[] levelsArr = KllHelper.createLevelsArray((long)weight);
        Assert.assertEquals((int)levelsArr.length, (int)8);
        int[] correct = new int[]{0, 0, 0, 1, 2, 2, 3, 4};
        for (int i = 0; i < levelsArr.length; ++i) {
            Assert.assertEquals((int)levelsArr[i], (int)correct[i]);
        }
        KllMiscLongsTest.outputLevels(weight, levelsArr);
    }

    private static void outputLevels(int weight, int[] levelsArr) {
        String[] hdr = new String[]{"Lvl", "StartAdr", "BitPattern", "Weight"};
        String hdrfmt = "%3s %9s %10s %s" + Util.LS;
        String dfmt = "%3d %9d %10d %d" + Util.LS;
        String dfmt_2 = "%3d %9d %s" + Util.LS;
        KllMiscLongsTest.println("Count = " + weight + " => " + Integer.toBinaryString(weight));
        KllMiscLongsTest.println("LevelsArr");
        KllMiscLongsTest.printf(hdrfmt, hdr);
        for (int i = 0; i < levelsArr.length; ++i) {
            if (i == levelsArr.length - 1) {
                KllMiscLongsTest.printf(dfmt_2, i, levelsArr[i], "ItemsArr.length");
                continue;
            }
            int j = Util.bitAt((long)weight, (int)i);
            KllMiscLongsTest.printf(dfmt, i, levelsArr[i], j, 1 << i);
        }
        KllMiscLongsTest.println("");
    }

    @Test
    public void viewMemorySketchData() {
        int k = 20;
        int n = 109;
        boolean withLevels = true;
        boolean withLevelsAndItems = true;
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((long)i);
        }
        byte[] byteArr = sk.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArr);
        KllLongsSketch fltSk = KllLongsSketch.wrap((Memory)mem);
        KllMiscLongsTest.println(fltSk.toString(withLevels, withLevelsAndItems));
        Assert.assertEquals((long)fltSk.getN(), (long)n);
    }

    @Test
    public void checkIntCapAux() {
        String[] hdr = new String[]{"level", "depth", "wt", "cap", "(end)", "MaxN"};
        String hdrFmt = "%6s %6s %28s %10s %10s %34s" + Util.LS;
        String dataFmt = "%6d %6d %,28d %,10d %,10d %,34d" + Util.LS;
        int k = 1000;
        int m = 8;
        int numLevels = 20;
        KllMiscLongsTest.println("k=" + k + ", m=" + m + ", numLevels=" + numLevels);
        KllMiscLongsTest.printf(hdrFmt, hdr);
        long maxN = 0L;
        long[] correct = new long[]{0L, 1L, 1L, 2L, 2L, 3L, 5L, 8L, 12L, 17L, 26L, 39L, 59L, 88L, 132L, 198L, 296L, 444L, 667L, 1000L};
        for (int i = 0; i < numLevels; ++i) {
            int depth = numLevels - i - 1;
            long cap = KllHelper.intCapAux((int)k, (int)depth);
            long end = Math.max((long)m, cap);
            long wt = 1L << i;
            KllMiscLongsTest.printf(dataFmt, i, depth, wt, cap, end, maxN += wt * end);
            Assert.assertEquals((long)cap, (long)correct[i]);
        }
    }

    @Test
    public void checkIntCapAuxAux() {
        String[] hdr = new String[]{"d", "twoK", "2k*2^d", "3^d", "tmp=2k*2^d/3^d", "(tmp + 1)/2", "(end)"};
        String hdrFmt = "%6s %10s %20s %20s %15s %12s %10s" + Util.LS;
        String dataFmt = "%6d %10d %,20d %,20d %15d %12d %10d" + Util.LS;
        long k = 65535L;
        long m = 8L;
        KllMiscLongsTest.println("k = " + k + ", m = " + m);
        KllMiscLongsTest.printf(hdrFmt, hdr);
        long[] correct = new long[]{65535L, 43690L, 29127L, 19418L, 12945L, 8630L, 5753L, 3836L, 2557L, 1705L, 1136L, 758L, 505L, 337L, 224L, 150L, 100L, 67L, 44L, 30L, 20L, 13L, 9L, 6L, 4L, 3L, 2L, 1L, 1L, 1L, 0L};
        for (int i = 0; i < 31; ++i) {
            long twoK = k << 1;
            long twoKxtwoD = twoK << i;
            long threeToD = KllHelper.powersOfThree[i];
            long tmp = twoKxtwoD / threeToD;
            long result = tmp + 1L >>> 1;
            long end = Math.max(m, result);
            KllMiscLongsTest.printf(dataFmt, i, twoK, twoKxtwoD, threeToD, tmp, result, end);
            Assert.assertEquals((long)result, (long)correct[i]);
            Assert.assertEquals((long)result, (long)KllHelper.intCapAuxAux((long)k, (int)i));
        }
    }

    @Test
    public void checkGrowLevels() {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((long)i);
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure)[2], (int)33);
    }

    @Test
    public void checkSketchInitializeLongHeap() {
        int k = 20;
        KllMiscLongsTest.println("#### CASE: LONG FULL HEAP");
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((long)i);
        }
        KllMiscLongsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((long)sk.getMaxItem(), (long)21L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscLongsTest.println("#### CASE: LONG HEAP EMPTY");
        sk = KllLongsSketch.newHeapInstance((int)k);
        KllMiscLongsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscLongsTest.println("#### CASE: LONG HEAP SINGLE");
        sk = KllLongsSketch.newHeapInstance((int)k);
        sk.update(1L);
        KllMiscLongsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((long)sk.getMaxItem(), (long)1L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeLongHeapifyCompactMem() {
        int k = 20;
        KllMiscLongsTest.println("#### CASE: LONG FULL HEAPIFIED FROM COMPACT");
        KllLongsSketch sk2 = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((long)i);
        }
        byte[] compBytes = sk2.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscLongsTest.println(KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true));
        KllLongsSketch sk = KllLongsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((long)sk.getMaxItem(), (long)21L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscLongsTest.println("#### CASE: LONG EMPTY HEAPIFIED FROM COMPACT");
        sk2 = KllLongsSketch.newHeapInstance((int)k);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllLongsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscLongsTest.println("#### CASE: LONG SINGLE HEAPIFIED FROM COMPACT");
        sk2 = KllLongsSketch.newHeapInstance((int)k);
        sk2.update(1L);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllLongsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((long)sk.getMaxItem(), (long)1L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeLongHeapifyUpdatableMem() {
        int k = 20;
        KllMiscLongsTest.println("#### CASE: LONG FULL HEAPIFIED FROM UPDATABLE");
        KllLongsSketch sk2 = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((long)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscLongsTest.println(KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true));
        KllHeapLongsSketch sk = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((long)sk.getMaxItem(), (long)21L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscLongsTest.println("#### CASE: LONG EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllLongsSketch.newHeapInstance((int)k);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscLongsTest.println("#### CASE: LONG SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllLongsSketch.newHeapInstance((int)k);
        sk2.update(1L);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((long)sk.getMaxItem(), (long)1L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringLongCompact() {
        int k = 20;
        KllMiscLongsTest.println("#### CASE: LONG FULL COMPACT");
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((long)i);
        }
        byte[] compBytes = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscLongsTest.println(s);
        KllLongsSketch sk2 = KllLongsSketch.heapify((Memory)wmem);
        byte[] compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscLongsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscLongsTest.println("#### CASE: LONG EMPTY COMPACT");
        sk = KllLongsSketch.newHeapInstance((int)k);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscLongsTest.println(s);
        sk2 = KllLongsSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscLongsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscLongsTest.println("#### CASE: LONG SINGLE COMPACT");
        sk = KllLongsSketch.newHeapInstance((int)k);
        sk.update(1L);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscLongsTest.println(s);
        sk2 = KllLongsSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscLongsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
    }

    @Test
    public void checkMemoryToStringLongUpdatable() {
        int k = 20;
        KllMiscLongsTest.println("#### CASE: LONG FULL UPDATABLE");
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((long)i);
        }
        byte[] upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])upBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscLongsTest.println(s);
        KllHeapLongsSketch sk2 = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        byte[] upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscLongsTest.println(s);
        Assert.assertEquals((long)sk.getN(), (long)sk2.getN());
        Assert.assertEquals((long)sk.getMinItem(), (long)sk2.getMinItem());
        Assert.assertEquals((long)sk.getMaxItem(), (long)sk2.getMaxItem());
        Assert.assertEquals((int)sk.getNumRetained(), (int)sk2.getNumRetained());
        KllMiscLongsTest.println("#### CASE: LONG EMPTY UPDATABLE");
        sk = KllLongsSketch.newHeapInstance((int)k);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscLongsTest.println(s);
        sk2 = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscLongsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscLongsTest.println("#### CASE: LONG SINGLE UPDATABLE");
        sk = KllLongsSketch.newHeapInstance((int)k);
        sk.update(1L);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscLongsTest.println(s);
        sk2 = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscLongsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscLongsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int m = 8;
        int n1 = 21;
        int n2 = 43;
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        WritableMemory wmem2 = WritableMemory.allocate((int)3000);
        KllDirectLongsSketch sk1 = KllDirectLongsSketch.newDirectUpdatableInstance((int)k, (int)m, (WritableMemory)wmem, (MemoryRequestServer)this.memReqSvr);
        KllDirectLongsSketch sk2 = KllDirectLongsSketch.newDirectUpdatableInstance((int)k, (int)m, (WritableMemory)wmem2, (MemoryRequestServer)this.memReqSvr);
        for (i = 1; i <= n1; ++i) {
            sk1.update((long)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((long)(i + 100));
        }
        sk1.merge((KllSketch)sk2);
        Assert.assertEquals((long)sk1.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk1.getMaxItem(), (long)143L);
    }

    @Test
    public void checkGetSingleItem() {
        int k = 20;
        KllLongsSketch skHeap = KllLongsSketch.newHeapInstance((int)k);
        skHeap.update(1L);
        Assert.assertTrue((boolean)(skHeap instanceof KllHeapLongsSketch));
        Assert.assertEquals((long)skHeap.getLongSingleItem(), (long)1L);
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])KllHelper.toByteArray((KllSketch)skHeap, (boolean)true));
        KllLongsSketch skDirect = KllLongsSketch.writableWrap((WritableMemory)srcMem, (MemoryRequestServer)this.memReqSvr);
        Assert.assertTrue((boolean)(skDirect instanceof KllDirectLongsSketch));
        Assert.assertEquals((long)skDirect.getLongSingleItem(), (long)1L);
        Memory srcMem2 = Memory.wrap((byte[])skHeap.toByteArray());
        KllLongsSketch skCompact = KllLongsSketch.wrap((Memory)srcMem2);
        Assert.assertTrue((boolean)(skCompact instanceof KllDirectLongsSketch.KllDirectCompactLongsSketch));
        Assert.assertEquals((long)skCompact.getLongSingleItem(), (long)1L);
    }

    @Test
    public void printlnTest() {
        String s = "PRINTING:  printf in " + this.getClass().getName();
        KllMiscLongsTest.println(s);
        KllMiscLongsTest.printf("%s" + Util.LS, s);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

