/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.annotations.Test;

public class MemoryReadWriteSafetyTest {
    final WritableMemory mem = (WritableMemory)Memory.wrap((byte[])new byte[8]);

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutByte() {
        this.mem.putByte(0L, (byte)1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutShort() {
        this.mem.putShort(0L, (short)1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutChar() {
        this.mem.putChar(0L, '\u0001');
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutInt() {
        this.mem.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutLong() {
        this.mem.putLong(0L, 1L);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutFloat() {
        this.mem.putFloat(0L, 1.0f);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutDouble() {
        this.mem.putDouble(0L, 1.0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutByteArray() {
        this.mem.putByteArray(0L, new byte[]{1}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutShortArray() {
        this.mem.putShortArray(0L, new short[]{1}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutCharArray() {
        this.mem.putCharArray(0L, new char[]{'\u0001'}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutIntArray() {
        this.mem.putIntArray(0L, new int[]{1}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutLongArray() {
        this.mem.putLongArray(0L, new long[]{1L}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testPutFloatArray() {
        this.mem.putFloatArray(0L, new float[]{1.0f}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testDoubleByteArray() {
        this.mem.putDoubleArray(0L, new double[]{1.0}, 0, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testWritableMemoryRegion() {
        WritableMemory mem1 = (WritableMemory)WritableMemory.allocate((int)8).region(0L, 8L);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testByteArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((byte[])new byte[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testByteArrayWrapWithBO() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((byte[])new byte[8], (ByteOrder)ByteOrder.nativeOrder());
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testByteArrayWrapWithOffsetsAndBO() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((byte[])new byte[8], (int)0, (int)4, (ByteOrder)ByteOrder.nativeOrder());
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testShortArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((short[])new short[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testCharArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((char[])new char[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testIntArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((int[])new int[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLongArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((long[])new long[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testFloatArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((float[])new float[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testDoubleArrayWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((double[])new double[8]);
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testByteBufferWrap() {
        WritableMemory mem1 = (WritableMemory)Memory.wrap((ByteBuffer)ByteBuffer.allocate(8));
        mem1.putInt(0L, 1);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testMapFile() throws Exception {
        File tempFile = File.createTempFile("test", null);
        tempFile.deleteOnExit();
        try (RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");){
            raf.setLength(8L);
            Memory mem = null;
            mem = Memory.map((File)tempFile);
            try (ResourceScope scope = mem.scope();){
                ((WritableMemory)mem).putInt(0L, 1);
            }
        }
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testMapFileWithOffsetsAndBO() throws Exception {
        File tempFile = File.createTempFile("test", "test");
        tempFile.deleteOnExit();
        new RandomAccessFile(tempFile, "rw").setLength(8L);
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            Memory mem = Memory.map((File)tempFile, (long)0L, (long)4L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder());
            ((WritableMemory)mem).putInt(0L, 1);
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testMapFileBeyondTheFileSize() throws Exception {
        File tempFile = File.createTempFile("test", "test");
        tempFile.deleteOnExit();
        try (RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");){
            raf.setLength(8L);
            try (ResourceScope scope = ResourceScope.newConfinedScope();){
                Memory.map((File)tempFile, (long)0L, (long)16L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder());
            }
        }
    }
}

