/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.pig.cpc.SketchToString;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SketchToStringTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void nullInputTuple() throws Exception {
        SketchToString func = new SketchToString();
        String result = (String)func.exec(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyInputTuple() throws Exception {
        SketchToString func = new SketchToString();
        String result = (String)func.exec(TUPLE_FACTORY.newTuple());
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() throws Exception {
        SketchToString func = new SketchToString();
        CpcSketch sketch = new CpcSketch();
        String result = (String)func.exec(TUPLE_FACTORY.newTuple((Object)new DataByteArray(sketch.toByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void normalCaseWithDetail() throws Exception {
        SketchToString func = new SketchToString("true");
        CpcSketch sketch = new CpcSketch();
        String result = (String)func.exec(TUPLE_FACTORY.newTuple((Object)new DataByteArray(sketch.toByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void normalCaseWithDetailAndSeed() throws Exception {
        SketchToString func = new SketchToString("true", "123");
        CpcSketch sketch = new CpcSketch(12, 123L);
        String result = (String)func.exec(TUPLE_FACTORY.newTuple((Object)new DataByteArray(sketch.toByteArray())));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.length() > 0 ? 1 : 0) != 0);
    }
}

