/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_7
extends UpgradeChange {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String UPGRADE_REQUIRED = "XCL47";
    private static final String GRANT_REVOKE_WITH_LEGACY_ACCESS = "42Z60";

    public Changes10_7(String string) {
        super(string);
    }

    public static Test suite(int n) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Upgrade test for 10.7");
        baseTestSuite.addTestSuite(Changes10_7.class);
        return new SupportFilesSetup((Test)baseTestSuite);
    }

    public void testBoolean() throws SQLException {
        String string = "create function f_4655( a varchar( 100 ) ) returns boolean\nlanguage java parameter style java no sql deterministic\nexternal name 'Z.getBooleanValue'\n";
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_7.assertFalse((boolean)this.getSupportedTypes().contains("BOOLEAN"));
                Changes10_7.assertStatementError(SYNTAX_ERROR, statement, string);
                break;
            }
            case 1: {
                Changes10_7.assertFalse((boolean)this.getSupportedTypes().contains("BOOLEAN"));
                Changes10_7.assertStatementError(UPGRADE_REQUIRED, statement, string);
                break;
            }
            case 3: {
                Changes10_7.assertTrue((boolean)this.getSupportedTypes().contains("BOOLEAN"));
                statement.execute(string);
            }
        }
        statement.close();
    }

    private Set<String> getSupportedTypes() throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = this.getConnection().getMetaData().getTypeInfo();
        while (resultSet.next()) {
            hashSet.add(resultSet.getString("TYPE_NAME"));
        }
        resultSet.close();
        return hashSet;
    }

    public void testAlterTableDropColumnAndTriggerAction() throws Exception {
        if (!this.oldAtLeast(10, 3)) {
            return;
        }
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                this.createTableAndTrigger("TAB1_SOFT_UPGRADE_RESTRICT", "TAB1_SOFT_UPGRADE_RESTRICT_TR1", true);
                this.createTableAndTrigger("TAB1_SOFT_UPGRADE_CASCADE", "TAB1_SOFT_UPGRADE_CASCADE_TR1", true);
                this.createTableAndTrigger("TAB2_SOFT_UPGRADE_RESTRICT", "TAB2_SOFT_UPGRADE_RESTRICT_TR1", false);
                this.createTableAndTrigger("TAB2_SOFT_UPGRADE_CASCADE", "TAB2_SOFT_UPGRADE_CASCADE_TR1", false);
                this.createTableAndTrigger("TAB1_POSTSOFT_UPGRADE_RESTRICT", "TAB1_POSTSOFT_UPGRADE_RESTRICT_TR1", true);
                this.createTableAndTrigger("TAB1_POSTSOFT_UPGRADE_CASCADE", "TAB1_POSTSOFT_UPGRADE_CASCADE_TR1", true);
                this.createTableAndTrigger("TAB2_POSTSOFT_UPGRADE_RESTRICT", "TAB2_POSTSOFT_UPGRADE_RESTRICT_TR1", false);
                this.createTableAndTrigger("TAB2_POSTSOFT_UPGRADE_CASCADE", "TAB2_POSTSOFT_UPGRADE_CASCADE_TR1", false);
                this.createTableAndTrigger("TAB1_HARD_UPGRADE_RESTRICT", "TAB1_HARD_UPGRADE_RESTRICT_TR1", true);
                this.createTableAndTrigger("TAB1_HARD_UPGRADE_CASCADE", "TAB1_HARD_UPGRADE_CASCADE_TR1", true);
                this.createTableAndTrigger("TAB2_HARD_UPGRADE_RESTRICT", "TAB2_HARD_UPGRADE_RESTRICT_TR1", false);
                this.createTableAndTrigger("TAB2_HARD_UPGRADE_CASCADE", "TAB2_HARD_UPGRADE_CASCADE_TR1", false);
                break;
            }
            case 1: {
                Changes10_7.assertStatementError("X0Y25", statement, " alter table TAB1_SOFT_UPGRADE_RESTRICT  drop column c11 restrict");
                ResultSet resultSet = statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_SOFT_UPGRADE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TAB1_SOFT_UPGRADE_RESTRICT_TR1"}});
                statement.executeUpdate("alter table TAB1_SOFT_UPGRADE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(statement, "01502");
                JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_SOFT_UPGRADE_CASCADE_TR1'"));
                Changes10_7.assertStatementError("X0Y25", statement, " alter table TAB2_SOFT_UPGRADE_RESTRICT  drop column c11 restrict");
                resultSet = statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_SOFT_UPGRADE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TAB2_SOFT_UPGRADE_RESTRICT_TR1"}});
                statement.executeUpdate("alter table TAB2_SOFT_UPGRADE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(statement, "01502");
                JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_SOFT_UPGRADE_CASCADE_TR1'"));
                this.createTableAndTrigger("TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", true);
                Changes10_7.assertStatementError("X0Y25", statement, " alter table TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT  drop column c11 restrict");
                resultSet = statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TAB1_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1"}});
                this.createTableAndTrigger("TAB1_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB1_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", true);
                statement.executeUpdate("alter table TAB1_SOFT_UPGRADE_NEW_TABLE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(statement, "01502");
                JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1'"));
                this.createTableAndTrigger("TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", false);
                Changes10_7.assertStatementError("X0Y25", statement, " alter table TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT  drop column c11 restrict");
                resultSet = statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TAB2_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1"}});
                this.createTableAndTrigger("TAB2_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB2_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", false);
                statement.executeUpdate("alter table TAB2_soft_upgrade_NEW_TABLE_cascade  drop column c11 CASCADE");
                this.checkWarning(statement, "01502");
                JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1'"));
                break;
            }
            case 2: {
                this.incorrectBehaviorForDropColumn("TAB1_POSTSOFT_UPGRADE_RESTRICT", "TAB1_POSTSOFT_UPGRADE_RESTRICT_TR1", "RESTRICT");
                this.incorrectBehaviorForDropColumn("TAB1_POSTSOFT_UPGRADE_CASCADE", "TAB1_POSTSOFT_UPGRADE_CASCADE_TR1", "CASCADE");
                this.incorrectBehaviorForDropColumn("TAB2_POSTSOFT_UPGRADE_RESTRICT", "TAB2_POSTSOFT_UPGRADE_RESTRICT_TR1", "RESTRICT");
                this.incorrectBehaviorForDropColumn("TAB2_POSTSOFT_UPGRADE_CASCADE", "TAB2_POSTSOFT_UPGRADE_CASCADE_TR1", "CASCADE");
                this.createTableAndTrigger("TAB1_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB1_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", true);
                this.incorrectBehaviorForDropColumn("TAB1_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB1_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", "RESTRICT");
                this.createTableAndTrigger("TAB1_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB1_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", true);
                this.incorrectBehaviorForDropColumn("TAB1_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB1_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", "RESTRICT");
                this.createTableAndTrigger("TAB2_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB2_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", false);
                this.incorrectBehaviorForDropColumn("TAB2_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT", "TAB2_POST_SOFT_UPGRADE_NEW_TABLE_RESTRICT_TR1", "RESTRICT");
                this.createTableAndTrigger("TAB2_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB2_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", false);
                this.incorrectBehaviorForDropColumn("TAB2_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE", "TAB2_POST_SOFT_UPGRADE_NEW_TABLE_CASCADE_TR1", "RESTRICT");
                break;
            }
            case 3: {
                Changes10_7.assertStatementError("X0Y25", statement, " alter table TAB1_HARD_UPGRADE_RESTRICT  drop column c11 restrict");
                ResultSet resultSet = statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_HARD_UPGRADE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TAB1_HARD_UPGRADE_RESTRICT_TR1"}});
                statement.executeUpdate("alter table TAB1_HARD_UPGRADE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(statement, "01502");
                JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_HARD_UPGRADE_CASCADE_TR1'"));
                Changes10_7.assertStatementError("X0Y25", statement, " alter table TAB2_HARD_UPGRADE_RESTRICT  drop column c11 restrict");
                resultSet = statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_HARD_UPGRADE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TAB2_HARD_UPGRADE_RESTRICT_TR1"}});
                statement.executeUpdate("alter table TAB2_HARD_UPGRADE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(statement, "01502");
                JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_HARD_UPGRADE_CASCADE_TR1'"));
                this.createTableAndTrigger("TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT", "TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1", true);
                Changes10_7.assertStatementError("X0Y25", statement, " alter table TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT  drop column c11 restrict");
                resultSet = statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TAB1_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1"}});
                this.createTableAndTrigger("TAB1_HARD_UPGRADE_NEW_TABLE_CASCADE", "TAB1_HARD_UPGRADE_NEW_TABLE_CASCADE_TR1", true);
                statement.executeUpdate("alter table TAB1_HARD_UPGRADE_NEW_TABLE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(statement, "01502");
                JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB1_HARD_UPGRADE_NEW_TABLE_CASCADE_TR1'"));
                this.createTableAndTrigger("TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT", "TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1", false);
                Changes10_7.assertStatementError("X0Y25", statement, " alter table TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT  drop column c11 restrict");
                resultSet = statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1'");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"TAB2_HARD_UPGRADE_NEW_TABLE_RESTRICT_TR1"}});
                this.createTableAndTrigger("TAB2_HARD_UPGRADE_NEW_TABLE_CASCADE", "TAB2_HARD_UPGRADE_NEW_TABLE_CASCADE_TR1", false);
                statement.executeUpdate("alter table TAB2_HARD_UPGRADE_NEW_TABLE_CASCADE  drop column c11 CASCADE");
                this.checkWarning(statement, "01502");
                JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='TAB2_HARD_UPGRADE_NEW_TABLE_CASCADE_TR1'"));
            }
        }
    }

    private void createTableAndTrigger(String string, String string2, boolean bl) throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE " + string + " (c11 int, c12 int) ");
        statement.execute("INSERT INTO " + string + " VALUES (1,10)");
        statement.execute("CREATE TRIGGER " + string2 + " AFTER UPDATE OF c12 ON " + string + (bl ? " REFERENCING OLD AS oldt" : "") + " FOR EACH ROW SELECT " + (bl ? "oldt.c11 " : "c11 ") + "FROM " + string);
        statement.executeUpdate("UPDATE " + string + " SET c12=c12+1");
    }

    private void incorrectBehaviorForDropColumn(String string, String string2, String string3) throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("ALTER TABLE " + string + " DROP COLUMN c11 " + string3);
        ResultSet resultSet = statement.executeQuery(" select triggername from sys.systriggers where triggername='" + string2 + "'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{string2}});
    }

    private void checkWarning(Statement statement, String string) throws Exception {
        SQLWarning sQLWarning = null;
        sQLWarning = statement.getWarnings();
        if (sQLWarning == null) {
            sQLWarning = this.getConnection().getWarnings();
        }
        Changes10_7.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
        Changes10_7.assertSQLState(string, sQLWarning);
    }

    public void testTriggers() throws SQLException {
        Statement statement = this.createStatement();
        boolean bl = this.oldAtLeast(10, 3);
        switch (this.getPhase()) {
            case 0: {
                statement.execute("CREATE TABLE DERBY1482_table1(c11 int, c12 int)");
                statement.execute("INSERT INTO DERBY1482_table1 VALUES (1,10)");
                statement.execute("CREATE TABLE DERBY1482_table2(c21 int, c22 int)");
                statement.execute("CREATE TABLE DERBY1482_table3(c31 int, c32 int)");
                statement.execute("CREATE TABLE DERBY1482_table4(c41 int, c42 int)");
                statement.execute("CREATE TABLE DERBY1482_table5(c51 int, c52 int)");
                statement.execute("CREATE TRIGGER tr1 AFTER UPDATE OF c12 ON DERBY1482_table1 REFERENCING OLD AS oldt FOR EACH ROW " + (bl ? "" : "MODE DB2SQL ") + "INSERT INTO DERBY1482_table2 VALUES(-1, oldt.c12)");
                statement.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
                break;
            }
            case 1: {
                statement.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}});
                statement.execute("CREATE TRIGGER tr2 AFTER UPDATE OF c12 ON DERBY1482_table1 REFERENCING OLD AS oldt FOR EACH ROW " + (bl ? "" : "MODE DB2SQL ") + "INSERT INTO DERBY1482_table3 VALUES(-1, oldt.c12)");
                statement.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"3"}});
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
                break;
            }
            case 2: {
                statement.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"4"}});
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}});
                statement.execute("CREATE TRIGGER tr3 AFTER UPDATE OF c12 ON DERBY1482_table1 REFERENCING OLD AS oldt FOR EACH ROW " + (bl ? "" : "MODE DB2SQL ") + "INSERT INTO DERBY1482_table4 VALUES(-1, oldt.c12)");
                statement.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"5"}});
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"3"}});
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table4");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
                break;
            }
            case 3: {
                statement.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"6"}});
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"4"}});
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table4");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}});
                statement.execute("CREATE TRIGGER tr4 AFTER UPDATE OF c12 ON DERBY1482_table1 REFERENCING OLD AS oldt FOR EACH ROW " + (bl ? "" : "MODE DB2SQL ") + "INSERT INTO DERBY1482_table5 VALUES(-1, oldt.c12)");
                statement.executeUpdate("UPDATE DERBY1482_table1 SET c12=-1 WHERE c11=1");
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table2");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"7"}});
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table3");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"5"}});
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table4");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"3"}});
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM DERBY1482_table5");
                JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
            }
        }
        statement.close();
    }

    public void testExternalSecuritySpecification() throws SQLException {
        String string = "create function f_4551( a varchar( 100 ) ) returns int\nlanguage java parameter style java reads sql data\nexternal security definer\nexternal name 'Z.getIntValue'\n";
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: 
            case 2: {
                Changes10_7.assertStatementError(SYNTAX_ERROR, statement, string);
                break;
            }
            case 1: {
                Changes10_7.assertStatementError(UPGRADE_REQUIRED, statement, string);
                break;
            }
            case 3: {
                Changes10_7.assertStatementError(GRANT_REVOKE_WITH_LEGACY_ACCESS, statement, string);
            }
        }
        statement.close();
    }
}

