/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.Vector;

public class SimpleDiff {
    private static final String[] NOISE = new String[]{"WARNING: The Security Manager is deprecated and will be removed in a future release.", "WARNING: A command line option has enabled the Security Manager", "WARNING: The Security Manager is deprecated and will be removed in a future release"};
    PrintWriter pw;
    boolean debugOn = Boolean.getBoolean("simplediff.debug");
    int debugLevel = 1;
    boolean diffsFound = true;
    int lookAhead = 20;
    public static String usage = "java SimpleDiff <file1> <file2>";

    public void debug(int n, String string) {
        if (this.debugLevel >= n) {
            this.debug(string);
        }
    }

    public void debug(String string) {
        if (this.debugOn) {
            System.out.println("DEBUG: " + string);
        }
    }

    int lineCount(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            ++n;
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return n;
    }

    public String[] readFile(BufferedReader bufferedReader) throws IOException {
        Vector<String> vector = new Vector<String>();
        String string = "";
        string = bufferedReader.readLine();
        while (string != null) {
            vector.addElement(string);
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        Object[] objectArray = new String[vector.size()];
        this.debug(2, vector.size() + " lines in input");
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void printFile(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.pw.println(i + ": " + stringArray[i]);
            System.out.println(i + ": " + stringArray[i]);
        }
    }

    public String[] diffFiles(DiffBuffer diffBuffer, DiffBuffer diffBuffer2) throws IOException {
        int n = 0;
        int n2 = 0;
        Vector<CallSite> vector = new Vector<CallSite>();
        while (diffBuffer.isValidOffset(n) && diffBuffer2.isValidOffset(n2)) {
            int n3;
            int n4;
            String string;
            String string2 = diffBuffer.lineAt(n);
            if (string2.equals(string = diffBuffer2.lineAt(n2))) {
                this.debug(1, n + ": match");
                diffBuffer.setLowWater(++n);
                diffBuffer2.setLowWater(++n2);
                continue;
            }
            boolean bl = false;
            int n5 = n2;
            for (n4 = 1; diffBuffer2.isValidOffset(n2 + n4) && n4 < this.lookAhead; ++n4) {
                this.debug(1, "currentLine1 " + n + "  currentLine2 " + (n2 + n4));
                this.debug(1, "about to reference file2[" + (n2 + n4) + "]");
                string = diffBuffer2.lineAt(n2 + n4);
                this.debug(2, "did");
                if (!string2.equals(string)) continue;
                bl = true;
                if (n4 > 1) {
                    vector.addElement((CallSite)((Object)(n + "a" + (n2 + 1) + "," + (n2 + n4))));
                } else {
                    vector.addElement((CallSite)((Object)(n + "a" + (n2 + 1))));
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    vector.addElement((CallSite)((Object)("> " + diffBuffer2.lineAt(n2 + n3))));
                }
                n2 += n4;
                n4 = 0;
                break;
            }
            if (!bl && diffBuffer2.isValidOffset(n2)) {
                n3 = n;
                string = diffBuffer2.lineAt(n2);
                for (n4 = 1; diffBuffer.isValidOffset(n + n4) && n4 < this.lookAhead; ++n4) {
                    this.debug(1, "currentLine2 " + n2 + "  currentLine1 " + (n + n4));
                    string2 = diffBuffer.lineAt(n + n4);
                    if (!string.equals(string2)) continue;
                    bl = true;
                    if (n4 > 1) {
                        vector.addElement((CallSite)((Object)(n + 1 + "," + (n + n4) + "d" + n2)));
                    } else {
                        vector.addElement((CallSite)((Object)(n + 1 + "d" + n2)));
                    }
                    for (int i = 0; i < n4; ++i) {
                        vector.addElement((CallSite)((Object)("< " + diffBuffer.lineAt(n + i))));
                    }
                    n += n4;
                    n4 = 0;
                    this.debug(1, "continuing");
                    break;
                }
            }
            if (!bl) {
                this.debug(1, n + ": NOMATCH");
                vector.addElement((CallSite)((Object)(n + 1 + " del")));
                vector.addElement((CallSite)((Object)("< " + diffBuffer.lineAt(n))));
                ++n;
                continue;
            }
            diffBuffer.setLowWater(++n);
            diffBuffer2.setLowWater(++n2);
        }
        if (diffBuffer.isValidOffset(n)) {
            vector.addElement((CallSite)((Object)(n2 + " del")));
            int n6 = n;
            while (diffBuffer.isValidOffset(n6)) {
                vector.addElement((CallSite)((Object)("< " + diffBuffer.lineAt(n6))));
                ++n6;
            }
        }
        if (diffBuffer2.isValidOffset(n2)) {
            vector.addElement((CallSite)((Object)(n + " add")));
            int n7 = n2;
            while (diffBuffer2.isValidOffset(n7)) {
                vector.addElement((CallSite)((Object)("> " + diffBuffer2.lineAt(n7))));
                ++n7;
            }
        }
        diffBuffer.close();
        diffBuffer2.close();
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void reportMemory() {
        this.reportMemory(null);
    }

    private void reportMemory(String string) {
        if (string != null) {
            System.out.println(string);
        }
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        System.out.println("total:         " + l2);
        System.out.println("free:          " + l);
        System.out.println("used:          " + (l2 - l));
        System.gc();
        System.out.println("used: <postgc> " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        System.out.println("  ");
    }

    public boolean doWork(BufferedReader bufferedReader, BufferedReader bufferedReader2, PrintWriter printWriter) throws IOException {
        this.pw = printWriter == null ? new PrintWriter(System.out) : printWriter;
        try {
            DiffBuffer diffBuffer = new DiffBuffer(bufferedReader, "1");
            DiffBuffer diffBuffer2 = new DiffBuffer(bufferedReader2, "2");
            String[] stringArray = this.diffFiles(diffBuffer, diffBuffer2);
            if (stringArray == null) {
                this.debug(1, "no diff");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.pw.println(stringArray[i]);
                System.out.println(stringArray[i]);
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException comparing <" + bufferedReader + "> and <" + bufferedReader2 + ">");
            System.err.println(iOException);
            this.pw.println("IOException comparing <" + bufferedReader + "> and <" + bufferedReader2 + ">");
            this.pw.println(iOException);
        }
        return true;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            System.err.println("Invalid number of arguments");
            System.err.println("Usage: " + usage);
            System.exit(1);
        }
        SimpleDiff simpleDiff = new SimpleDiff();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader(stringArray[1]));
            simpleDiff.doWork(bufferedReader, bufferedReader2, null);
        }
        catch (IOException iOException) {
            System.out.println("IOExeption: " + iOException);
        }
    }

    public void pause() {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(System.in);
        try {
            bufferedInputStream.read();
        }
        catch (IOException iOException) {
            this.pw.println("Error trying to pause...");
            System.out.println("Error trying to pause...");
        }
    }

    class DiffBuffer
    extends Vector<String> {
        public final String EMPTY;
        protected BufferedReader readBuffer;
        protected int currentLowWater;
        protected int currentHighWater;
        private int oldLow;
        protected String myName;
        protected boolean atEnd;
        protected int actualEndOfFile;

        public boolean atEOF() {
            return this.atEnd;
        }

        public DiffBuffer(BufferedReader bufferedReader) {
            this(bufferedReader, "");
        }

        public DiffBuffer(BufferedReader bufferedReader, String string) {
            this(bufferedReader, string, 1024);
        }

        public DiffBuffer(BufferedReader bufferedReader, String string, int n) {
            super(n);
            this.EMPTY = null;
            this.readBuffer = bufferedReader;
            this.currentLowWater = 0;
            this.currentHighWater = -1;
            this.oldLow = 0;
            this.myName = string;
            this.atEnd = false;
        }

        public boolean isValidOffset(int n) throws IOException {
            if (this.atEnd) {
                return n <= this.actualEndOfFile;
            }
            return this.lineAt(n) != null;
        }

        public String lineAt(int n) throws IOException {
            if (n > this.currentHighWater) {
                for (int i = 0; i < n - this.currentHighWater; ++i) {
                    String string = null;
                    while ((string = this.readBuffer.readLine()) != null && this.ignoreLine(string)) {
                    }
                    this.addElement(string);
                    if (string != null || this.atEnd) continue;
                    this.actualEndOfFile = this.currentHighWater + i;
                    this.atEnd = true;
                }
                this.currentHighWater = n;
            }
            return (String)this.elementAt(n);
        }

        public boolean ignoreLine(String string) {
            for (String string2 : NOISE) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        public void setLowWater(int n) {
            for (int i = this.oldLow; i < n; ++i) {
                this.setElementAt(this.EMPTY, i);
            }
            this.currentLowWater = n;
            this.oldLow = n - 1;
        }

        public void iterate(boolean bl) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.size(); ++i) {
                if (this.elementAt(i) == null) {
                    if (bl) {
                        System.out.print("[" + i + "] ");
                        System.out.println("null");
                    }
                    ++n;
                    continue;
                }
                if (bl) {
                    System.out.print("[" + i + "] ");
                    System.out.println("NotNULL");
                }
                ++n2;
            }
            System.out.println("nulls: " + n + "  nonNull: " + n2);
        }

        public void close() throws IOException {
            this.readBuffer.close();
            this.readBuffer = null;
        }
    }
}

