/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURBaseTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURDataModelSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class HoldabilityTest
extends SURBaseTest {
    private static final String selectStatement = "select * from t1";

    public HoldabilityTest(String string) {
        super(string, 1000);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(HoldabilityTest.class);
    }

    protected void setUp() throws Exception {
        SURDataModelSetup.createDataModel(SURDataModelSetup.SURDataModel.MODEL_WITH_PK, this.getConnection(), this.recordCount);
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        this.commit();
        super.tearDown();
    }

    public void testHeldForwardOnlyResultSetScanInit() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery(selectStatement);
        this.commit();
        this.scrollForward(resultSet);
        statement.close();
    }

    public void testHeldForwardOnlyResultSetScanInProgress() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery(selectStatement);
        for (int i = 0; i < this.recordCount / 2; ++i) {
            resultSet.next();
            this.verifyTuple(resultSet);
        }
        this.commit();
        while (resultSet.next()) {
            this.verifyTuple(resultSet);
        }
        statement.close();
    }

    public void testHeldForwardOnlyUpdatableResultSetScanInit() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        this.commit();
        resultSet.next();
        this.updateTuple(resultSet);
        this.scrollForward(resultSet);
        statement.close();
    }

    public void testCompressOnHeldForwardOnlyUpdatableResultSetScanInProgress() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        for (int i = 0; i < this.recordCount / 2; ++i) {
            resultSet.next();
            this.verifyTuple(resultSet);
        }
        this.updateTuple(resultSet);
        this.commit();
        this.verifyResultSetUpdatableAfterCompress(resultSet);
        statement.close();
    }

    public void testCompressOnHeldForwardOnlyUpdatableResultSetScanInit() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        this.commit();
        this.verifyResultSetUpdatableAfterCompress(resultSet);
        statement.close();
    }

    public void testHeldForwardOnlyUpdatableResultSetScanInProgress() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        for (int i = 0; i < this.recordCount / 2; ++i) {
            resultSet.next();
            this.verifyTuple(resultSet);
        }
        this.updateTuple(resultSet);
        this.commit();
        resultSet.next();
        this.updateTuple(resultSet);
        while (resultSet.next()) {
            this.verifyTuple(resultSet);
        }
        statement.close();
    }

    public void testHeldScrollableResultSetScanInit() throws SQLException {
        Statement statement = this.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        this.commit();
        this.scrollForward(resultSet);
        this.scrollBackward(resultSet);
        statement.close();
    }

    public void testHeldScrollableResultSetScanInProgress() throws SQLException {
        Statement statement = this.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        for (int i = 0; i < this.recordCount / 2; ++i) {
            resultSet.next();
            this.verifyTuple(resultSet);
        }
        this.commit();
        while (resultSet.next()) {
            this.verifyTuple(resultSet);
        }
        this.scrollBackward(resultSet);
        statement.close();
    }

    public void testHeldScrollableResultSetScanDone() throws SQLException {
        Statement statement = this.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        this.scrollForward(resultSet);
        this.commit();
        this.scrollBackward(resultSet);
        statement.close();
    }

    public void testHeldScrollableUpdatableResultSetScanInit() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        if (resultSet.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        this.commit();
        this.scrollForward(resultSet);
        this.scrollBackwardAndUpdate(resultSet);
        statement.close();
    }

    public void testHeldScrollableUpdatableResultSetScanInProgress() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        if (resultSet.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        for (int i = 0; i < this.recordCount / 2; ++i) {
            resultSet.next();
            this.verifyTuple(resultSet);
        }
        this.commit();
        while (resultSet.next()) {
            this.verifyTuple(resultSet);
        }
        this.scrollBackwardAndUpdate(resultSet);
        statement.close();
    }

    public void testHeldScrollableUpdatableResultSetScanDone() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        if (resultSet.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        this.scrollForward(resultSet);
        this.commit();
        this.scrollBackwardAndUpdate(resultSet);
        statement.close();
    }

    public void testUpdateRowAfterCommitOnHeldForwardOnlyResultSet() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        if (resultSet.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        resultSet.next();
        this.commit();
        try {
            resultSet.updateInt(2, -100);
            resultSet.updateRow();
            HoldabilityTest.fail((String)"Expected updateRow() to throw exception");
        }
        catch (SQLException sQLException) {
            HoldabilityTest.assertEquals((String)"Unexpected SQLState", (String)"24000", (String)sQLException.getSQLState());
        }
        statement.close();
    }

    public void testUpdateRowAfterCommitOnHeldScrollInsensitiveResultSet() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        if (resultSet.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        resultSet.next();
        this.commit();
        try {
            resultSet.updateInt(2, -100);
            resultSet.updateRow();
            HoldabilityTest.fail((String)"Expected updateRow() to throw exception");
        }
        catch (SQLException sQLException) {
            HoldabilityTest.assertEquals((String)"Unexpected SQLState", (String)"24000", (String)sQLException.getSQLState());
        }
        statement.close();
    }

    public void testCompressOnHeldScrollableUpdatableResultSetScanInit() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        if (resultSet.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        this.commit();
        this.verifyResultSetUpdatableAfterCompress(resultSet);
        statement.close();
    }

    public void testCompressOnHeldScrollableUpdatableResultSetScanInProgress() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        if (resultSet.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        resultSet.next();
        this.commit();
        this.verifyCompressInvalidation(resultSet);
        statement.close();
    }

    public void testCompressOnHeldScrollableUpdatableResultSetScanDone() throws SQLException {
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery(selectStatement);
        if (resultSet.getConcurrency() == 1007) {
            HoldabilityTest.fail((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY");
        }
        this.scrollForward(resultSet);
        this.commit();
        this.verifyCompressInvalidation(resultSet);
        statement.close();
    }

    private void verifyResultSetUpdatableAfterCompress(ResultSet resultSet) throws SQLException {
        Statement statement = this.createStatement();
        int n = statement.executeUpdate("delete from T1 where id>0");
        int n2 = this.recordCount - 1;
        statement.close();
        HoldabilityTest.assertEquals((String)"Invalid number of records deleted", (int)n2, (int)n);
        this.commit();
        this.onlineCompress(true, true, true);
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values (?,?,?,?,?)");
        for (int i = 0; i < this.recordCount * 2; ++i) {
            int n3 = i + this.recordCount + 1000;
            preparedStatement.setInt(1, n3);
            preparedStatement.setInt(2, n3);
            preparedStatement.setInt(3, n3 * 2 + 17);
            preparedStatement.setString(4, "m" + n3);
            preparedStatement.setString(5, "c" + n3);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
        this.commit();
        resultSet.next();
        this.updateTuple(resultSet);
        SQLWarning sQLWarning = resultSet.getWarnings();
        HoldabilityTest.assertNull((String)"Expected no warning when updating this row", (Object)sQLWarning);
        if (resultSet.getType() != 1003) {
            resultSet.last();
            this.updateTuple(resultSet);
            sQLWarning = resultSet.getWarnings();
            HoldabilityTest.assertNull((String)"Expected no warning when updating this row", (Object)sQLWarning);
            resultSet.first();
            this.updateTuple(resultSet);
            sQLWarning = resultSet.getWarnings();
            HoldabilityTest.assertNull((String)"Expected no warning when updating this row", (Object)sQLWarning);
        }
        this.commit();
        resultSet = this.createStatement().executeQuery(selectStatement);
        while (resultSet.next()) {
            this.verifyTuple(resultSet);
        }
        resultSet.close();
    }

    private void verifyCompressInvalidation(ResultSet resultSet) throws SQLException {
        Statement statement = this.createStatement();
        int n = statement.executeUpdate("delete from T1 where id>0");
        int n2 = this.recordCount - 1;
        statement.close();
        HoldabilityTest.assertEquals((String)"Invalid number of records deleted", (int)n2, (int)n);
        this.commit();
        this.onlineCompress(true, true, true);
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values (?,?,?,?,?)");
        for (int i = 0; i < this.recordCount * 2; ++i) {
            int n3 = i + this.recordCount + 1000;
            preparedStatement.setInt(1, n3);
            preparedStatement.setInt(2, n3);
            preparedStatement.setInt(3, n3 * 2 + 17);
            preparedStatement.setString(4, "m" + n3);
            preparedStatement.setString(5, "c" + n3);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
        this.commit();
        resultSet.last();
        resultSet.updateInt(2, -100);
        resultSet.updateRow();
        SQLWarning sQLWarning = resultSet.getWarnings();
        this.assertWarning(sQLWarning, "01001");
        resultSet.clearWarnings();
        resultSet.first();
        resultSet.updateInt(2, -100);
        this.updateTuple(resultSet);
        sQLWarning = resultSet.getWarnings();
        this.assertWarning(sQLWarning, "01001");
        this.commit();
        resultSet = this.createStatement().executeQuery(selectStatement);
        while (resultSet.next()) {
            this.verifyTuple(resultSet);
        }
        resultSet.close();
    }

    private void onlineCompress(boolean bl, boolean bl2, boolean bl3) throws SQLException {
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(1);
        PreparedStatement preparedStatement = connection.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, "T1");
        preparedStatement.setBoolean(3, bl);
        preparedStatement.setBoolean(4, bl2);
        preparedStatement.setBoolean(5, bl3);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.commit();
        connection.close();
    }
}

