/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Bug5054Test
extends BaseJDBCTestCase {
    public Bug5054Test(String string) {
        super(string);
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Bug5054Test");
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(Bug5054Test.class)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("CREATE TABLE T1 (a integer, b integer)");
                statement.executeUpdate("INSERT INTO T1 VALUES(1, 1)");
                statement.executeUpdate("INSERT INTO T1 VALUES(2, 2)");
            }
        };
        baseTestSuite.addTest((Test)cleanDatabaseTestSetup);
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)cleanDatabaseTestSetup));
        return baseTestSuite;
    }

    public void testBugBug5054() throws SQLException {
        Statement statement = this.createStatement();
        statement.setCursorName("aBc");
        ResultSet resultSet = statement.executeQuery("select * from t1 for update");
        resultSet.next();
        Statement statement2 = this.createStatement();
        statement2.execute("update t1 set b=11 where current of \"" + resultSet.getCursorName() + "\"");
        Statement statement3 = this.createStatement();
        resultSet = statement3.executeQuery("SELECT * FROM T1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11"}, {"2", "2"}});
        resultSet.close();
    }
}

