/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ResultSetTest
extends Wrapper41Test {
    private static final byte[] BYTES1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
    private static final byte[] BYTES2 = new byte[]{105, 104, 103, 102, 101, 101, 102, 103, 104, 105};
    private static final String str1 = "I am the main Input string and I will be Updated";
    private static final String str2 = "I am the string used to update";
    private static int insertKey = 0;
    private Statement stmt = null;
    private ResultSet rs = null;
    private int key = -1;

    public ResultSetTest(String string) {
        super(string);
    }

    protected void setUp() throws SQLException {
        this.key = ResultSetTest.requestKey();
        this.stmt = this.createStatement(1003, 1008);
        this.rs = this.stmt.executeQuery("SELECT * FROM SYS.SYSTABLES");
        this.rs.next();
    }

    @Override
    protected void tearDown() throws Exception {
        this.rs.close();
        this.stmt.close();
        this.rs = null;
        this.stmt = null;
        super.tearDown();
    }

    public void testGetNCharacterStreamIntNotImplemented() throws SQLException {
        try {
            this.rs.getNCharacterStream(1);
            ResultSetTest.fail((String)"ResultSet.getNCharacterStream(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNCharaterStreamStringNotImplemented() throws SQLException {
        try {
            this.rs.getNCharacterStream("some-column-name");
            ResultSetTest.fail((String)"ResultSet.getNCharacterStream(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNClobNotIntImplemented() throws SQLException {
        try {
            this.rs.getNClob(1);
            ResultSetTest.fail((String)"ResultSet.getNClob(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNClobStringNotImplemented() throws SQLException {
        try {
            this.rs.getNClob("some-column-name");
            ResultSetTest.fail((String)"ResultSet.getNClob(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNStringIntNotImplemented() throws SQLException {
        try {
            this.rs.getNString(1);
            ResultSetTest.fail((String)"ResultSet.getNString(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNStringStringNotImplemented() throws SQLException {
        try {
            this.rs.getNString("some-column-name");
            ResultSetTest.fail((String)"ResultSet.getNString(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetSQLXMLIntNotImplemented() throws SQLException {
        try {
            this.rs.getSQLXML(1);
            ResultSetTest.fail((String)"ResultSet.getSQLXML(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetSQLXMLStringNotImplemented() throws SQLException {
        try {
            this.rs.getSQLXML("some-column-name");
            ResultSetTest.fail((String)"ResultSet.getSQLXML(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNCharacterStreamIntNotImplemented() throws SQLException {
        try {
            this.rs.updateNCharacterStream(1, null, 0L);
            ResultSetTest.fail((String)"ResultSet.updateNCharacterStream(int, Reader, int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNCharacterStreamIntLengthLessNotImplemented() throws SQLException {
        try {
            this.rs.updateNCharacterStream(1, null);
            ResultSetTest.fail((String)"ResultSet.updateNCharacterStream(int, Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNCharacterStreamStringNotImplemented() throws SQLException {
        try {
            this.rs.updateNCharacterStream("some-column-name", null, 0L);
            ResultSetTest.fail((String)"ResultSet.updateNCharacterStream(String, Reader, 0) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNCharacterStreamStringLengthlessNotImplemented() throws SQLException {
        try {
            this.rs.updateNCharacterStream("some-column-name", null);
            ResultSetTest.fail((String)"ResultSet.updateNCharacterStream(String, Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNClobIntNotImplemented() throws SQLException {
        try {
            this.rs.updateNClob(1, (NClob)null);
            ResultSetTest.fail((String)"ResultSet.updateNClob(int, NClob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNClobIntLengthlessNotImplemented() throws SQLException {
        try {
            this.rs.updateNClob(1, (Reader)null);
            ResultSetTest.fail((String)"ResultSet.updateNClob(int, Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNClobStringNotImplemented() throws SQLException {
        try {
            this.rs.updateNClob("some-column-name", (NClob)null);
            ResultSetTest.fail((String)"ResultSet.updateNClob(String, NClob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNClobStringLengthlessNotImplemented() throws SQLException {
        try {
            this.rs.updateNClob("some-column-name", (Reader)null);
            ResultSetTest.fail((String)"ResultSet.updateNClob(String, Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNStringIntNotImplemented() throws SQLException {
        try {
            this.rs.updateNString(1, null);
            ResultSetTest.fail((String)"ResultSet.updateNString(int, String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNStringStringNotImplemented() throws SQLException {
        try {
            this.rs.updateNString("some-column-name", null);
            ResultSetTest.fail((String)"ResultSet.updateNString(String, String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateSQLXMLIntNotImplemented() throws SQLException {
        try {
            this.rs.updateSQLXML(1, null);
            ResultSetTest.fail((String)"ResultSet.updateSQLXML(int, SQLXML) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateSQLXMLStringNotImplemented() throws SQLException {
        try {
            this.rs.updateSQLXML("some-column-name", null);
            ResultSetTest.fail((String)"ResultSet.updateSQLXML(String, SQLXML) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateBinaryStream() throws Exception {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dLongBit");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongBit", this.key);
        resultSet.next();
        resultSet.updateBinaryStream(1, (InputStream)byteArrayInputStream2, BYTES2.length);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongBit", this.key);
        resultSet.next();
        InputStream inputStream = resultSet.getBinaryStream(1);
        inputStream.read(byArray);
        inputStream.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateBinaryStream", (byte)BYTES2[i], (byte)byArray[i]);
        }
        resultSet.close();
    }

    public void testUpdateAsciiStream() throws Exception {
        this.stmt.execute("create table UpdateTestTable_ResultSet (sno int, datacol LONG VARCHAR)");
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prepareStatement("insert into UpdateTestTable_ResultSet values(?,?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.stmt.executeQuery("select * from UpdateTestTable_ResultSet for update");
        resultSet.next();
        resultSet.updateAsciiStream(2, (InputStream)byteArrayInputStream2, BYTES2.length);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.stmt.executeQuery("select * from UpdateTestTable_ResultSet");
        resultSet.next();
        InputStream inputStream = resultSet.getAsciiStream(2);
        inputStream.read(byArray);
        inputStream.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateAsciiStream", (byte)BYTES2[i], (byte)byArray[i]);
        }
        resultSet.close();
        this.stmt.execute("drop table UpdateTestTable_ResultSet");
    }

    public void testUpdateCharacterStream() throws Exception {
        String string = "Test data";
        String string2 = "Test data used for update";
        StringReader stringReader = new StringReader(string);
        StringReader stringReader2 = new StringReader(string2);
        PreparedStatement preparedStatement = this.prep("dLongVarchar");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setCharacterStream(2, (Reader)stringReader, string.length());
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongVarchar", this.key);
        resultSet.next();
        resultSet.updateCharacterStream(1, (Reader)stringReader2, string2.length());
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongVarchar", this.key);
        resultSet.next();
        StringReader stringReader3 = (StringReader)resultSet.getCharacterStream(1);
        char[] cArray = new char[string2.length()];
        stringReader3.read(cArray);
        String string3 = new String(cArray);
        ResultSetTest.assertEquals((String)("Error in updateCharacterStream" + string3), (String)string2, (String)string3);
        resultSet.close();
    }

    public void testUpdateBinaryStreamStringParameterName() throws Exception {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dLongBit");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongBit", this.key);
        resultSet.next();
        resultSet.updateBinaryStream("dLongBit", (InputStream)byteArrayInputStream2, BYTES2.length);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongBit", this.key);
        resultSet.next();
        InputStream inputStream = resultSet.getBinaryStream(1);
        inputStream.read(byArray);
        inputStream.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateBinaryStream", (byte)BYTES2[i], (byte)byArray[i]);
        }
        resultSet.close();
    }

    public void testUpdateBinaryStreamLengthless() throws IOException, SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dLongBit");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, byteArrayInputStream);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongBit", this.key);
        resultSet.next();
        resultSet.updateBinaryStream(1, (InputStream)byteArrayInputStream2);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongBit", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), resultSet.getBinaryStream(1));
        resultSet.close();
    }

    public void testUpdateBinaryStreamLengthlessBlob() throws IOException, SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dBlob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, byteArrayInputStream);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dBlob", this.key);
        resultSet.next();
        resultSet.updateBinaryStream(1, (InputStream)byteArrayInputStream2);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dBlob", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), resultSet.getBinaryStream(1));
        resultSet.close();
    }

    public void testUpdateBinaryStreamLengthlessParameterName() throws IOException, SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dLongBit");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, byteArrayInputStream);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongBit", this.key);
        resultSet.next();
        resultSet.updateBinaryStream("dLongBit", (InputStream)byteArrayInputStream2);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongBit", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), resultSet.getBinaryStream(1));
        resultSet.close();
    }

    public void testUpdateAsciiStreamStringParameterName() throws Exception {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dLongVarchar");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongVarchar", this.key);
        resultSet.next();
        resultSet.updateAsciiStream("dLongVarchar", (InputStream)byteArrayInputStream2, BYTES2.length);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongVarchar", this.key);
        resultSet.next();
        InputStream inputStream = resultSet.getAsciiStream(1);
        inputStream.read(byArray);
        inputStream.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateAsciiStream", (byte)BYTES2[i], (byte)byArray[i]);
        }
        resultSet.close();
    }

    public void testUpdateAsciiStreamLengthless() throws IOException, SQLException {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dLongVarchar");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongVarchar", this.key);
        resultSet.next();
        resultSet.updateAsciiStream(1, (InputStream)byteArrayInputStream2);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongVarchar", this.key);
        resultSet.next();
        InputStream inputStream = resultSet.getAsciiStream(1);
        inputStream.read(byArray);
        inputStream.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateAsciiStream", (byte)BYTES2[i], (byte)byArray[i]);
        }
        resultSet.close();
    }

    public void testUpdateAsciiStreamLengthlessParameterName() throws IOException, SQLException {
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dLongVarchar");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongVarchar", this.key);
        resultSet.next();
        resultSet.updateAsciiStream("dLongVarchar", (InputStream)byteArrayInputStream2);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongVarchar", this.key);
        resultSet.next();
        InputStream inputStream = resultSet.getAsciiStream(1);
        inputStream.read(byArray);
        inputStream.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateAsciiStream", (byte)BYTES2[i], (byte)byArray[i]);
        }
        resultSet.close();
    }

    public void testUpdateCharacterStreamStringParameterName() throws Exception {
        String string = "Test data";
        String string2 = "Test data used for update";
        StringReader stringReader = new StringReader(string);
        StringReader stringReader2 = new StringReader(string2);
        PreparedStatement preparedStatement = this.prep("dLongVarchar");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setCharacterStream(2, (Reader)stringReader, string.length());
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongVarchar", this.key);
        resultSet.next();
        resultSet.updateCharacterStream("dLongVarchar", (Reader)stringReader2, string2.length());
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongVarchar", this.key);
        resultSet.next();
        StringReader stringReader3 = (StringReader)resultSet.getCharacterStream(1);
        char[] cArray = new char[string2.length()];
        stringReader3.read(cArray);
        String string3 = new String(cArray);
        ResultSetTest.assertEquals((String)("Error in updateCharacterStream" + string3), (String)string2, (String)string3);
        resultSet.close();
    }

    public void testUpdateCharacterStreamLengthless() throws IOException, SQLException {
        String string = "This is the (\u0fff\u1234) test string";
        String string2 = "An updated (\u0fef\u9876) test string";
        PreparedStatement preparedStatement = this.prep("dLongVarchar");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setCharacterStream(2, new StringReader(string));
        preparedStatement.execute();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongVarchar", this.key);
        resultSet.next();
        resultSet.updateCharacterStream(1, (Reader)new StringReader(string2));
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongVarchar", this.key);
        resultSet.next();
        Reader reader = resultSet.getCharacterStream(1);
        for (int i = 0; i < string2.length(); ++i) {
            ResultSetTest.assertEquals((String)("Strings differ at index " + i), (int)string2.charAt(i), (int)reader.read());
        }
        ResultSetTest.assertEquals((String)"Too much data in stream", (int)-1, (int)reader.read());
        reader.close();
    }

    public void testUpdateCharacterStreamLengthlessParameterName() throws IOException, SQLException {
        String string = "This is the (\u0fff\u1234) test string";
        String string2 = "An updated (\u0fef\u9876) test string";
        PreparedStatement preparedStatement = this.prep("dLongVarchar");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setCharacterStream(2, new StringReader(string));
        preparedStatement.execute();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dLongVarchar", this.key);
        resultSet.next();
        resultSet.updateCharacterStream("dLongVarchar", (Reader)new StringReader(string2));
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dLongVarchar", this.key);
        resultSet.next();
        Reader reader = resultSet.getCharacterStream(1);
        for (int i = 0; i < string2.length(); ++i) {
            ResultSetTest.assertEquals((String)("Strings differ at index " + i), (int)string2.charAt(i), (int)reader.read());
        }
        ResultSetTest.assertEquals((String)"Too much data in stream", (int)-1, (int)reader.read());
        reader.close();
    }

    public void testUpdateClob() throws Exception {
        this.getConnection().setAutoCommit(false);
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dClob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        int n = ResultSetTest.requestKey();
        preparedStatement.setInt(1, n);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream2, BYTES2.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dClob", this.key);
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        resultSet.close();
        resultSet = this.fetchUpd("dClob", n);
        resultSet.next();
        resultSet.updateClob(1, clob);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dClob", n);
        resultSet.next();
        ResultSetTest.assertEquals(clob, resultSet.getClob(1));
        resultSet.close();
    }

    public void testUpdateClobLengthless() throws Exception {
        this.getConnection().setAutoCommit(false);
        StringReader stringReader = new StringReader(new String(BYTES1));
        StringReader stringReader2 = new StringReader(new String(BYTES2));
        PreparedStatement preparedStatement = this.prep("dClob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setCharacterStream(2, stringReader);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dClob", this.key);
        resultSet.next();
        resultSet.updateClob(1, (Reader)stringReader2);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dClob", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new StringReader(new String(BYTES2)), resultSet.getCharacterStream(1));
        resultSet.close();
    }

    public void testUpdateClobwithLengthofIS() throws Exception {
        StringReader stringReader = new StringReader(str1);
        StringReader stringReader2 = new StringReader(str2);
        PreparedStatement preparedStatement = this.prep("dClob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setCharacterStream(2, stringReader);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dClob", this.key);
        resultSet.next();
        resultSet.updateClob(1, (Reader)stringReader2, (long)str2.length());
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dClob", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new StringReader(str2), resultSet.getCharacterStream(1));
        resultSet.close();
    }

    public void testUpdateBlob() throws Exception {
        this.getConnection().setAutoCommit(false);
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dBlob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        int n = ResultSetTest.requestKey();
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream2, BYTES2.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetch("dBlob", this.key);
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        resultSet.close();
        resultSet = this.fetchUpd("dBlob", n);
        resultSet.next();
        resultSet.updateBlob(1, blob);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dBlob", n);
        resultSet.next();
        ResultSetTest.assertEquals(blob, resultSet.getBlob(1));
        resultSet.close();
    }

    public void testUpdateBlobLengthless() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dBlob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, byteArrayInputStream);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dBlob", this.key);
        resultSet.next();
        resultSet.updateBlob(1, (InputStream)byteArrayInputStream2);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dBlob", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), resultSet.getBinaryStream(1));
        resultSet.close();
    }

    public void testUpdateBlobWithLengthofIS() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dBlob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, byteArrayInputStream);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dBlob", this.key);
        resultSet.next();
        resultSet.updateBlob(1, (InputStream)byteArrayInputStream2, (long)BYTES2.length);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dBlob", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), resultSet.getBinaryStream(1));
        resultSet.close();
    }

    public void testUpdateBlobStringParameterNameWithLengthofIS() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dBlob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, byteArrayInputStream);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dBlob", this.key);
        resultSet.next();
        resultSet.updateBlob("dBlob", (InputStream)byteArrayInputStream2, (long)BYTES2.length);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dBlob", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), resultSet.getBinaryStream(1));
        resultSet.close();
    }

    public void testUpdateClobStringParameterName() throws Exception {
        this.getConnection().setAutoCommit(false);
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dClob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        int n = ResultSetTest.requestKey();
        preparedStatement.setInt(1, n);
        preparedStatement.setAsciiStream(2, (InputStream)byteArrayInputStream2, BYTES2.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetch("dClob", this.key);
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        resultSet.close();
        resultSet = this.fetchUpd("dClob", n);
        resultSet.next();
        resultSet.updateClob("dClob", clob);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dClob", n);
        resultSet.next();
        ResultSetTest.assertEquals(clob, resultSet.getClob(1));
        resultSet.close();
    }

    public void testUpdateClobLengthlessParameterName() throws Exception {
        StringReader stringReader = new StringReader(new String(BYTES1));
        StringReader stringReader2 = new StringReader(new String(BYTES2));
        PreparedStatement preparedStatement = this.prep("dClob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setCharacterStream(2, stringReader);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dClob", this.key);
        resultSet.next();
        resultSet.updateClob("dClob", (Reader)stringReader2);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dClob", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new StringReader(new String(BYTES2)), resultSet.getCharacterStream(1));
        resultSet.close();
    }

    public void testUpdateClobStringParameterNameWithLengthofIS() throws Exception {
        StringReader stringReader = new StringReader(str1);
        StringReader stringReader2 = new StringReader(str2);
        PreparedStatement preparedStatement = this.prep("dClob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setCharacterStream(2, stringReader);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dClob", this.key);
        resultSet.next();
        resultSet.updateClob("dClob", (Reader)stringReader2, (long)str2.length());
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dClob", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new StringReader(str2), resultSet.getCharacterStream(1));
        resultSet.close();
    }

    public void testUpdateBlobStringParameterName() throws Exception {
        this.getConnection().setAutoCommit(false);
        byte[] byArray = new byte[10];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dBlob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, BYTES1.length);
        preparedStatement.executeUpdate();
        int n = ResultSetTest.requestKey();
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream2, BYTES2.length);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetch("dBlob", this.key);
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        resultSet.close();
        resultSet = this.fetchUpd("dBlob", n);
        resultSet.next();
        resultSet.updateBlob("dBlob", blob);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dBlob", n);
        resultSet.next();
        ResultSetTest.assertEquals(blob, resultSet.getBlob(1));
        resultSet.close();
    }

    public void testUpdateBlobWithStreamLengthlessParameterName() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement preparedStatement = this.prep("dBlob");
        preparedStatement.setInt(1, this.key);
        preparedStatement.setBinaryStream(2, byteArrayInputStream);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        ResultSet resultSet = this.fetchUpd("dBlob", this.key);
        resultSet.next();
        resultSet.updateBlob("dBlob", (InputStream)byteArrayInputStream2);
        resultSet.updateRow();
        resultSet.close();
        resultSet = this.fetch("dBlob", this.key);
        resultSet.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), resultSet.getBinaryStream(1));
        resultSet.close();
    }

    public void testGetHoldability() throws SQLException, Exception {
        int n;
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values(1)");
        ResultSetTest.assertEquals((String)"default holdability is HOLD_CURSORS_OVER_COMMIT", (int)1, (int)resultSet.getHoldability());
        resultSet.close();
        try {
            resultSet.getHoldability();
            ResultSetTest.fail((String)"getHoldability() should fail when closed");
        }
        catch (SQLException sQLException) {
            ResultSetTest.assertSQLState("XCL16", sQLException);
            ResultSetTest.assertTrue((sQLException.getMessage().indexOf("getHoldability") > 0 ? 1 : 0) != 0);
        }
        int[] nArray = new int[]{1, 2};
        for (n = 0; n < nArray.length; ++n) {
            Statement statement2 = this.createStatement(1003, 1007, nArray[n]);
            resultSet = statement2.executeQuery("values(1)");
            ResultSetTest.assertEquals((String)("holdability " + ResultSetTest.holdabilityString(nArray[n])), (int)nArray[n], (int)resultSet.getHoldability());
            resultSet.close();
            statement2.close();
        }
        statement.execute("create procedure getresultsetwithhold(in hold int) parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.jdbc4.ResultSetTest.getResultSetWithHoldability' dynamic result sets 1 reads sql data");
        for (n = 0; n < nArray.length; ++n) {
            for (int i = 0; i < nArray.length; ++i) {
                CallableStatement callableStatement = this.prepareCall("call getresultsetwithhold(?)", 1003, 1007, nArray[n]);
                callableStatement.setInt(1, nArray[i]);
                callableStatement.execute();
                resultSet = callableStatement.getResultSet();
                ResultSetTest.assertSame((Object)callableStatement, (Object)resultSet.getStatement());
                int n2 = resultSet.getHoldability();
                ResultSetTest.assertEquals((String)("holdability of ResultSet from stored proc: " + ResultSetTest.holdabilityString(n2)), (int)nArray[i], (int)n2);
                this.commit();
                try {
                    resultSet.next();
                    ResultSetTest.assertEquals((String)"non-holdable result set not closed on commit", (int)1, (int)n2);
                }
                catch (SQLException sQLException) {
                    ResultSetTest.assertSQLState("XCL16", sQLException);
                    ResultSetTest.assertEquals((String)"holdable result set closed on commit", (int)2, (int)n2);
                }
                resultSet.close();
                callableStatement.close();
            }
        }
        statement.execute("drop procedure getresultsetwithhold");
        statement.close();
        this.commit();
    }

    public void testIsClosed() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values(1)");
        ResultSetTest.assertFalse((String)"rs should be open", (boolean)resultSet.isClosed());
        while (resultSet.next()) {
        }
        ResultSetTest.assertFalse((String)"rs should be open", (boolean)resultSet.isClosed());
        resultSet.close();
        ResultSetTest.assertTrue((String)"rs should be closed", (boolean)resultSet.isClosed());
        resultSet = statement.executeQuery("values(1)");
        ResultSetTest.assertFalse((String)"rs should be open", (boolean)resultSet.isClosed());
        ResultSet resultSet2 = statement.executeQuery("values(1)");
        ResultSetTest.assertTrue((String)"rs should be closed", (boolean)resultSet.isClosed());
        ResultSetTest.assertFalse((String)"rs2 should be open", (boolean)resultSet2.isClosed());
        Statement statement2 = this.createStatement();
        resultSet = statement2.executeQuery("values(1)");
        ResultSetTest.assertFalse((String)"rs2 should be open", (boolean)resultSet2.isClosed());
        ResultSetTest.assertFalse((String)"rs should be open", (boolean)resultSet.isClosed());
        statement.execute("create procedure retrieve_result_sets() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.jdbc4.ResultSetTest.threeResultSets' dynamic result sets 3 reads sql data");
        statement.execute("call retrieve_result_sets()");
        ResultSet[] resultSetArray = new ResultSet[3];
        int n = 0;
        do {
            resultSetArray[n] = statement.getResultSet();
            ResultSetTest.assertFalse((String)("rss[" + n + "] should be open"), (boolean)resultSetArray[n].isClosed());
            if (n > 0) {
                ResultSetTest.assertTrue((String)("rss[" + (n - 1) + "] should be closed"), (boolean)resultSetArray[n - 1].isClosed());
            }
            ++n;
        } while (statement.getMoreResults());
        ResultSetTest.assertEquals((String)"expected three result sets", (int)3, (int)n);
        statement.execute("drop procedure retrieve_result_sets");
        resultSet = statement2.executeQuery("values(1)");
        statement2.close();
        ResultSetTest.assertTrue((String)"rs should be closed", (boolean)resultSet.isClosed());
        Connection connection = this.openDefaultConnection();
        statement2 = connection.createStatement();
        resultSet = statement2.executeQuery("values(1)");
        connection.close();
        ResultSetTest.assertTrue((String)"rs should be closed", (boolean)resultSet.isClosed());
        statement.close();
        statement2.close();
    }

    public void testIsClosedOnNonHoldableResultSet() throws SQLException {
        this.getConnection().setAutoCommit(false);
        this.getConnection().setHoldability(2);
        ResultSet resultSet = this.createStatement().executeQuery("SELECT TABLENAME FROM SYS.SYSTABLES");
        ResultSetTest.assertEquals((String)"ResultSet shouldn't be holdable", (int)2, (int)resultSet.getHoldability());
        this.commit();
        ResultSetTest.assertTrue((String)"Commit should have closed the ResultSet", (boolean)resultSet.isClosed());
    }

    public void testExceptionWhenClosed() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values(1)");
        resultSet.close();
        HashMap<String, Class[]> hashMap = new HashMap<String, Class[]>();
        HashMap<String, Integer[]> hashMap2 = new HashMap<String, Integer[]>();
        String[] stringArray = new String[]{"getWarnings", "clearWarnings", "getStatement", "getMetaData", "getConcurrency", "getHoldability", "getRow", "getType", "rowDeleted", "rowInserted", "rowUpdated", "getFetchDirection", "getFetchSize"};
        for (String string : stringArray) {
            hashMap.put(string, null);
            hashMap2.put(string, null);
        }
        for (String string : new String[]{"setFetchDirection", "setFetchSize"}) {
            hashMap.put(string, new Class[]{Integer.TYPE});
            hashMap2.put(string, new Integer[]{0});
        }
        for (String string : hashMap.keySet()) {
            Method method = resultSet.getClass().getMethod(string, (Class[])hashMap.get(string));
            try {
                method.invoke((Object)resultSet, (Object[])hashMap2.get(string));
                ResultSetTest.fail((String)("Unexpected Failure: method.invoke(rs, " + String.valueOf(hashMap2.get(string)) + ") should have failed."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof SQLException) {
                    SQLException sQLException = (SQLException)throwable;
                    String string2 = sQLException.getSQLState();
                    ResultSetTest.assertSQLState("XCL16", sQLException);
                    continue;
                }
                throw invocationTargetException;
            }
            ResultSetTest.fail((String)("no exception thrown for " + string + "() when ResultSet is closed"));
        }
        statement.close();
    }

    public void testWrapper() throws SQLException {
        Object object;
        Class<ResultSet> clazz;
        PreparedStatement preparedStatement = this.prepareStatement("select count(*) from sys.systables");
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.isWrapperFor(clazz = ResultSet.class)) {
            object = resultSet.unwrap(clazz);
        } else {
            ResultSetTest.assertFalse((String)"isWrapperFor wrongly returns false", (boolean)resultSet.isWrapperFor(clazz));
        }
        object = PreparedStatement.class;
        try {
            if (resultSet.isWrapperFor((Class<?>)object)) {
                ResultSetTest.assertTrue((String)"isWrapperFor wrongly returns true", (boolean)resultSet.isWrapperFor((Class<?>)object));
            } else {
                PreparedStatement preparedStatement2 = (PreparedStatement)resultSet.unwrap(object);
                ResultSetTest.fail((String)"unwrap does not throw the expected exception");
            }
        }
        catch (SQLException sQLException) {
            ResultSetTest.assertSQLState("XJ128", sQLException);
        }
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ResultSetTest suite");
        baseTestSuite.addTest(ResultSetTest.decorateTestSuite(TestConfiguration.defaultSuite(ResultSetTest.class, false)));
        return baseTestSuite;
    }

    private static Test decorateTestSuite(Test test) {
        return new BaseJDBCTestSetup(test){

            protected void setUp() throws SQLException {
                Connection connection = this.getConnection();
                Statement statement = connection.createStatement();
                statement.execute("create table UpdateTestTableResultSet (sno int not null unique,dBlob BLOB,dClob CLOB,dLongVarchar LONG VARCHAR,dLongBit LONG VARCHAR FOR BIT DATA)");
                statement.close();
            }

            @Override
            protected void tearDown() throws Exception {
                Connection connection = this.getConnection();
                Statement statement = connection.createStatement();
                statement.execute("drop table UpdateTestTableResultSet");
                statement.close();
                super.tearDown();
            }
        };
    }

    private static final int requestKey() {
        return ++insertKey;
    }

    private PreparedStatement prep(String string) throws SQLException {
        return this.prepareStatement("insert into UpdateTestTableResultSet (sno, " + string + ") values (?,?)");
    }

    private ResultSet fetchUpd(String string, int n) throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        return statement.executeQuery("select " + string + " from UpdateTestTableResultSet where sno = " + n + " for update");
    }

    private ResultSet fetch(String string, int n) throws SQLException {
        Statement statement = this.createStatement();
        return statement.executeQuery("select " + string + " from UpdateTestTableResultSet where sno = " + n);
    }

    private static String holdabilityString(int n) {
        switch (n) {
            case 1: {
                return "HOLD_CURSORS_OVER_COMMIT";
            }
            case 2: {
                return "CLOSE_CURSORS_AT_COMMIT";
            }
        }
        return "UNKNOWN HOLDABILITY";
    }

    public static void threeResultSets(ResultSet[] resultSetArray, ResultSet[] resultSetArray2, ResultSet[] resultSetArray3) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        resultSetArray[0] = statement.executeQuery("values(1)");
        Statement statement2 = connection.createStatement();
        resultSetArray2[0] = statement2.executeQuery("values(1)");
        Statement statement3 = connection.createStatement();
        resultSetArray3[0] = statement3.executeQuery("values(1)");
        connection.close();
    }

    public static void getResultSetWithHoldability(int n, ResultSet[] resultSetArray) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement(1003, 1007, n);
        resultSetArray[0] = statement.executeQuery("values (1), (2), (3)");
        connection.close();
    }

    public void testDerby1368() throws SQLException, IOException {
        this.testDerby1368(true);
        this.testDerby1368(false);
    }

    public void testDerby1368(boolean bl) throws SQLException, IOException {
        Statement statement = this.createStatement();
        statement.execute("create table T1368 (ID char(32) PRIMARY KEY, DATA blob(2G) not null)");
        int n = 0x100000;
        byte[] byArray = new byte[n];
        byArray[0] = 1;
        byArray[1] = 2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PreparedStatement preparedStatement = this.prepareStatement("insert into T1368 (ID, DATA) values (?, ?)");
        preparedStatement.setString(1, "id");
        if (bl) {
            preparedStatement.setBinaryStream(2, byteArrayInputStream);
        } else {
            preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, n);
        }
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select DATA from T1368 where ID = ?");
        preparedStatement.setString(1, "id");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Blob blob = resultSet.getBlob(1);
        ResultSetTest.assertEquals((long)n, (long)blob.length());
        InputStream inputStream = blob.getBinaryStream();
        ResultSetTest.assertEquals((int)1, (int)inputStream.read());
        while (inputStream.read() != -1) {
        }
        inputStream.close();
        inputStream = blob.getBinaryStream();
        ResultSetTest.assertEquals((long)n, (long)blob.length());
        ResultSetTest.assertEquals((int)1, (int)inputStream.read());
        inputStream.close();
        resultSet.close();
        statement.executeUpdate("DROP TABLE T1368");
    }

    public void testJDBC4_1() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, "create function makeBlob( ) returns blob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.jdbc4.ResultSetTest.makeBlob'\n");
        preparedStatement.execute();
        preparedStatement.close();
        this.vetDataTypeCount(connection);
        preparedStatement = this.prepareStatement(connection, "create table allTypes\n(\n    bigintCol bigint,\n    blobCol blob,\n    booleanCol boolean,\n    charCol char(1),\n    charForBitDataCol char(1) for bit data,\n    clobCol clob,\n    dateCol date,\n    doubleCol double,\n    floatCol float,\n    intCol int,\n    longVarcharCol long varchar,\n    longVarcharForBitDataCol long varchar for bit data,\n    numericCol numeric,\n    realCol real,\n    smallintCol smallint,\n    timeCol time,\n    timestampCol timestamp,\n    varcharCol varchar( 2 ),\n    varcharForBitDataCol varchar( 2 ) for bit data\n)\n");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = this.prepareStatement(connection, "insert into allTypes\n(\n    bigintCol,\n    blobCol,\n    booleanCol,\n    charCol,\n    charForBitDataCol,\n    clobCol,\n    dateCol,\n    doubleCol,\n    floatCol,\n    intCol,\n    longVarcharCol,\n    longVarcharForBitDataCol,\n    numericCol,\n    realCol,\n    smallintCol,\n    timeCol,\n    timestampCol,\n    varcharCol,\n    varcharForBitDataCol\n)\nvalues\n(\n    1,\n    makeBlob(  ),\n    true,\n    'a',\n    X'DE',\n    'abc',\n    date('1994-02-23'),\n    1.0,\n    1.0,\n    1,\n    'a',\n    X'DE',\n    1.0,\n    1.0,\n    1,\n    ?,\n    ?,\n    'a',\n    X'DE'\n)\n");
        preparedStatement.setTime(1, new Time(83342000L));
        preparedStatement.setTimestamp(2, new Timestamp(-229527385766L));
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = this.prepareStatement(connection, "insert into allTypes values ( null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null )");
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = this.prepareStatement(connection, "select * from allTypes order by bigintCol");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        this.examineJDBC4_1extensions(new Wrapper41(resultSet), false);
        resultSet.next();
        this.examineJDBC4_1extensions(new Wrapper41(resultSet), true);
        resultSet.close();
        preparedStatement.close();
        preparedStatement = this.prepareStatement(connection, "drop table allTypes");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = this.prepareStatement(connection, "drop function makeBlob");
        preparedStatement.execute();
        preparedStatement.close();
    }

    private void vetDataTypeCount(Connection connection) throws Exception {
        ResultSet resultSet = connection.getMetaData().getTypeInfo();
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        resultSet.close();
        ResultSetTest.assertEquals((int)22, (int)n);
    }

    public static final Blob makeBlob() throws Exception {
        return new HarmonySerialBlob(BINARY_VALUE);
    }
}

