/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public final class XMLXXETest
extends BaseJDBCTestCase {
    public XMLXXETest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("XML XXE Vulnerability tests\n");
        if (!XML.classpathMeetsXMLReqs()) {
            return baseTestSuite;
        }
        String[] stringArray = new String[]{"functionTests/tests/lang/xmlOptimizerXXE1Payload.trace", "functionTests/tests/lang/xmlOptimizerXXE1.trace", "functionTests/tests/lang/xmlOptimizerXXE2.trace"};
        baseTestSuite.addTest((Test)new SupportFilesSetup(TestConfiguration.defaultSuite(XMLXXETest.class), stringArray));
        return new LocaleTestSetup((Test)baseTestSuite, Locale.US);
    }

    public void testDerby6807FileAccess() throws Exception {
        File file = null;
        file = new File("test6807.txt");
        PrintWriter printWriter = new PrintWriter("test6807.txt", "UTF-8");
        printWriter.print("HelloWorld");
        printWriter.close();
        String string = file.getAbsolutePath();
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE xml_data(xml_col XML)");
        String string2 = "INSERT INTO xml_data(xml_col) VALUES(XMLPARSE(DOCUMENT'<!DOCTYPE foo [<!ENTITY xxe SYSTEM \"file:" + string + "\" >]><yolo>&xxe;</yolo>'PRESERVE WHITESPACE))";
        statement.execute(string2);
        JDBC.assertSingleValueResultSet(statement.executeQuery("SELECT XMLSERIALIZE(xml_col AS CLOB) FROM xml_data"), "<yolo/>");
        file.delete();
    }

    public void testDerby6807BillionLaughs() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table xml_billion_laughs( xml_col xml )");
        String string = "insert into xml_billion_laughs( xml_col ) values( xmlparse(document '<!DOCTYPE lolz [ <!ENTITY lol \"lol\"> <!ELEMENT lolz (#PCDATA)> <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\"> <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\"> <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\"> <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\"> <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\"> <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\"> <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\"> <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\"> <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">]><lolz>&lol9;</lolz>' PRESERVE WHITESPACE))";
        XMLXXETest.assertStatementError("2200M", statement, string);
    }

    public void testDerby6807FileAccessVTI() throws Exception {
        String string = "xmlOptimizerXXE1.trace";
        URL uRL = SupportFilesSetup.getReadOnlyURL(string);
        Statement statement = this.createStatement();
        statement.execute("create function decorationURLChildOnly\n(\n    urlString varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    childTags varchar( 32672 )...\n)\nreturns table\n(\n        conglomerateName varchar( 36 ),\n        joinStrategy varchar( 200 ),\n        estimatedCost double,\n        estimatedRowCount varchar( 200 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTIFromURL'\n");
        statement.execute("create view decorationURLChildOnly as\nselect * from table\n(\n    decorationURLChildOnly\n    (\n        '" + uRL.toString() + "',\n        'decoration',\n        'decConglomerateName', 'decJoinStrategy',\n        'ceEstimatedCost', 'ceEstimatedRowCount'\n    )\n) v\n");
        ResultSet resultSet = statement.executeQuery("select distinct conglomerateName, joinStrategy,                estimatedCost, estimatedRowCount\nfrom decorationURLChildOnly\nwhere conglomerateName like '%_A' and       estimatedCost is not null\norder by conglomerateName, joinStrategy,          estimatedCost, estimatedRowCount\n");
        XMLXXETest.assertTrue((boolean)resultSet.next());
        XMLXXETest.assertEquals((String)"null", (String)resultSet.getString(4).trim());
        XMLXXETest.assertFalse((boolean)resultSet.next());
    }

    public void testDerby6807BillionLaughsVTI() throws Exception {
        block2: {
            String string = "xmlOptimizerXXE2.trace";
            URL uRL = SupportFilesSetup.getReadOnlyURL(string);
            Statement statement = this.createStatement();
            statement.execute("create function lolzURL\n(\n    urlString varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    childTags varchar( 32672 )...\n)\nreturns table\n(\n        lolz varchar( 32000 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTIFromURL'\n");
            statement.execute("create view lolzURL as\nselect * from table\n(\n    lolzURL\n    (\n        '" + uRL.toString() + "',\n        'lolz'\n    )\n) v\n");
            try {
                ResultSet resultSet = statement.executeQuery("select lolz from lolzURL");
                XMLXXETest.assertTrue((boolean)resultSet.next());
                XMLXXETest.fail((String)"Expected SAXParseException");
            }
            catch (Throwable throwable) {
                if (throwable.getMessage().contains("entity expansions")) break block2;
                XMLXXETest.fail("Expected SAXParseException", throwable);
            }
        }
    }
}

