/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class st_reclaim_longcol
extends BaseJDBCTestCase {
    static boolean verbose = false;

    public st_reclaim_longcol(String string) {
        super(string);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(st_reclaim_longcol.class));
    }

    private void test1(int n, int n2) throws SQLException {
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[10];
        st_reclaim_longcol.println("test1:insert/delete of " + n2 + " rows with blob(" + n + ")");
        Arrays.fill(byArray, (byte)76);
        Arrays.fill(byArray2, (byte)83);
        Statement statement = this.createStatement();
        this.dropTable("LONGCOL");
        statement.execute("create table longcol (id int primary key not null, val blob(" + n + "))");
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("insert into longcol values (?, ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from longcol where id = ?");
        int n3 = 5;
        for (int i = 1; i < n2; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.executeUpdate();
            preparedStatement.setInt(1, -i);
            preparedStatement.setBytes(2, byArray2);
            preparedStatement.executeUpdate();
            preparedStatement2.setInt(1, i);
            preparedStatement2.executeUpdate();
            this.commit();
            this.wait_for_max_allocated("test1", ++n3);
        }
        ResultSet resultSet = this.getSpaceTable("LONGCOL");
        st_reclaim_longcol.assertTrue((String)"Space table was empty", (boolean)resultSet.next());
        int n4 = resultSet.getInt("NUMALLOCATEDPAGES");
        int n5 = resultSet.getInt("NUMFREEPAGES");
        int n6 = n4 + n5;
        st_reclaim_longcol.println("Space information after " + n2 + "insert/delete pairs of rows in longcol table containing " + n + "blobs:");
        this.printCurrentRow(resultSet);
        JDBC.assertEmpty(resultSet);
        int n7 = 12 + n2;
        if (n6 > n7) {
            st_reclaim_longcol.fail((String)("Test 1 failed, expected less than " + n7 + " pages - count is:\nfree pages     : " + n5 + "\nallocated pages: " + n4));
        }
        this.commit();
    }

    private void test2(int n, int n2, int n3) throws SQLException {
        int n4;
        int n5;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[10];
        st_reclaim_longcol.println("test2:queue of " + n2 + " rows with blob(" + n + "), total_work = " + n3);
        Arrays.fill(byArray, (byte)76);
        Arrays.fill(byArray2, (byte)83);
        Statement statement = this.createStatement();
        this.dropTable("LONGCOL");
        statement.execute("create table longcol (id int primary key not null, val blob(" + n + "))");
        PreparedStatement preparedStatement = this.prepareStatement("insert into longcol values (?, ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from longcol where id = ?");
        for (n5 = 0; n5 < n2; ++n5) {
            preparedStatement.setInt(1, n5);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.executeUpdate();
        }
        this.commit();
        for (n5 = n2; n5 < n3; ++n5) {
            preparedStatement.setInt(1, n5);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.executeUpdate();
            preparedStatement2.setInt(1, n5 - n2);
            preparedStatement2.executeUpdate();
            this.commit();
        }
        this.wait_for_max_allocated("test2", 10 * n2 + 5);
        ResultSet resultSet = this.getSpaceTable("LONGCOL");
        st_reclaim_longcol.assertTrue((String)"Space table was empty", (boolean)resultSet.next());
        int n6 = resultSet.getInt("NUMALLOCATEDPAGES") + resultSet.getInt("NUMFREEPAGES");
        st_reclaim_longcol.println("Space information:");
        this.printCurrentRow(resultSet);
        JDBC.assertEmpty(resultSet);
        this.commit();
        for (n4 = n3; n4 < n3 * 2; ++n4) {
            preparedStatement.setInt(1, n4);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.executeUpdate();
            preparedStatement2.setInt(1, n4 - n2);
            preparedStatement2.executeUpdate();
            this.commit();
        }
        this.wait_for_max_allocated("test2_2", 10 * n2 + 5);
        resultSet = this.getSpaceTable("LONGCOL");
        st_reclaim_longcol.assertTrue((String)"Space table was empty", (boolean)resultSet.next());
        n4 = resultSet.getInt("NUMALLOCATEDPAGES") + resultSet.getInt("NUMFREEPAGES");
        st_reclaim_longcol.println("Space information:");
        this.printCurrentRow(resultSet);
        JDBC.assertEmpty(resultSet);
        this.commit();
        if (n6 != n4) {
            st_reclaim_longcol.fail((String)("Test 2 failed, expected constant memory after second run.initial total = " + n6 + "second total = " + n4));
        }
    }

    private ResultSet getSpaceTable(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from table(syscs_diag.space_table(?)) t where isindex = 0");
        preparedStatement.setString(1, string);
        return preparedStatement.executeQuery();
    }

    private void printCurrentRow(ResultSet resultSet) throws SQLException {
        if (TestConfiguration.getCurrent().isVerbose()) {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                st_reclaim_longcol.println(resultSetMetaData.getColumnName(i) + ": " + String.valueOf(resultSet.getObject(i)));
            }
        }
    }

    private void wait_for_max_allocated(String string, int n) throws SQLException {
        st_reclaim_longcol.sleep(100L);
        Integer n2 = null;
        int n3 = 10000;
        int n4 = 100;
        while (true) {
            ResultSet resultSet = this.getSpaceTable("LONGCOL");
            st_reclaim_longcol.assertTrue((String)"Space table was empty", (boolean)resultSet.next());
            int n5 = resultSet.getInt("NUMALLOCATEDPAGES");
            int n6 = resultSet.getInt("NUMFREEPAGES");
            JDBC.assertEmpty(resultSet);
            if (n5 <= n) break;
            if (n2 == null) {
                n2 = n5;
            }
            if (n4 < n3) {
                n4 += 1000;
                st_reclaim_longcol.sleep(1000L);
                continue;
            }
            if (n5 < n2) {
                n2 = n5;
                n3 += 10000;
                continue;
            }
            st_reclaim_longcol.fail((String)("Test " + string + " failed in wait_for_max_allocated(), expected less than " + n + " allocated pages:\nfree pages     : " + n6 + "\nallocated pages: " + n5 + "\nWaited " + n4 + "ms. for background work."));
        }
    }

    public void testList() throws SQLException {
        this.setAutoCommit(false);
        this.test1(250000, 20);
    }
}

