/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;

public class OERandom {
    final Random rand;
    protected final int Clast;
    protected final int Cid;
    protected final int Citem;
    private static int[] RESCALE = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000};
    private StringBuffer decimalString = new StringBuffer(12);
    private final String[] SYLLABLES = new String[]{"BAR", "OUGHT", "ABLE", "PRI", "PRES", "ESE", "ANTI", "CALLY", "ATION", "EING"};
    private static final String[] left24 = new String[10];
    private static final String[] left300 = new String[10];
    private static final String[] right200 = new String[10];
    private static final String[] left10 = new String[10];
    private static final String[] right10 = new String[10];
    private static final String[] left14 = new String[10];
    private static final String[] left26 = new String[10];
    private static final String[] right24 = new String[10];
    private static final String[] left8 = new String[10];
    private static final String[] right8 = new String[10];
    private static boolean doneInit;

    public OERandom(OERandom oERandom) {
        this.rand = new Random(System.currentTimeMillis() + oERandom.rand.nextLong());
        this.Clast = oERandom.Clast;
        this.Cid = oERandom.Cid;
        this.Citem = oERandom.Citem;
    }

    public OERandom(int n, long l) {
        this.rand = new Random(l);
        this.Clast = n;
        this.Cid = this.randomInt(0, 255);
        this.Citem = this.randomInt(0, 255);
        this.initAStrings();
    }

    public OERandom(int n) {
        this(n, System.currentTimeMillis());
    }

    public String randomDecimalString(int n, int n2, int n3) {
        int n4 = this.randomInt(n, n2);
        int n5 = n4 / RESCALE[n3];
        int n6 = n4 % RESCALE[n3];
        this.decimalString.setLength(0);
        this.decimalString.append(n5);
        this.decimalString.append('.');
        int n7 = this.decimalString.length();
        this.decimalString.append(n6);
        int n8 = this.decimalString.length() - n7;
        if (n8 < n3) {
            for (int i = 0; i < n3 - n8; ++i) {
                this.decimalString.insert(n7, '0');
            }
        }
        return this.decimalString.toString();
    }

    public BigDecimal payment() {
        return this.randomDecimal(1, 500000, 2);
    }

    public BigDecimal randomDecimal(int n, int n2, int n3) {
        BigInteger bigInteger = BigInteger.valueOf(this.randomInt(n, n2));
        return new BigDecimal(bigInteger, n3);
    }

    public int randomInt(int n, int n2) {
        double d = this.rand.nextDouble();
        double d2 = d * (double)(n2 - n) + 0.5;
        return (int)d2 + n;
    }

    public short district() {
        return (short)this.randomInt(1, 10);
    }

    public short carrier() {
        return (short)this.randomInt(1, 10);
    }

    public int threshold() {
        return this.randomInt(10, 20);
    }

    public String randomAString(int n, int n2) {
        int n3 = this.randomInt(n, n2);
        char[] cArray = new char[n3];
        block22: for (int i = 0; i < n3; ++i) {
            double d = this.rand.nextDouble();
            if (i == 0) {
                if (d < 2.0) {
                    cArray[0] = (char)this.randomInt(65, 90);
                    continue;
                }
                switch (this.randomInt(1, 10)) {
                    case 1: {
                        cArray[0] = 192;
                        break;
                    }
                    case 2: {
                        cArray[0] = 193;
                        break;
                    }
                    case 3: {
                        cArray[0] = 194;
                        break;
                    }
                    case 4: {
                        cArray[0] = 202;
                        break;
                    }
                    case 5: {
                        cArray[0] = 203;
                        break;
                    }
                    case 6: {
                        cArray[0] = 212;
                        break;
                    }
                    case 7: {
                        cArray[0] = 216;
                        break;
                    }
                    case 8: {
                        cArray[0] = 209;
                        break;
                    }
                    case 9: {
                        cArray[0] = 205;
                        break;
                    }
                    default: {
                        cArray[0] = 220;
                        break;
                    }
                }
                continue;
            }
            if (d < 2.0) {
                cArray[i] = (char)this.randomInt(97, 122);
                continue;
            }
            switch (this.randomInt(1, 10)) {
                case 1: {
                    cArray[i] = 226;
                    continue block22;
                }
                case 2: {
                    cArray[i] = 228;
                    continue block22;
                }
                case 3: {
                    cArray[i] = 231;
                    continue block22;
                }
                case 4: {
                    cArray[i] = 232;
                    continue block22;
                }
                case 5: {
                    cArray[i] = 236;
                    continue block22;
                }
                case 6: {
                    cArray[i] = 239;
                    continue block22;
                }
                case 7: {
                    cArray[i] = 246;
                    continue block22;
                }
                case 8: {
                    cArray[i] = 249;
                    continue block22;
                }
                case 9: {
                    cArray[i] = 252;
                    continue block22;
                }
                default: {
                    cArray[i] = 229;
                }
            }
        }
        return new String(cArray);
    }

    public String randomNString(int n, int n2) {
        int n3 = this.randomInt(n, n2);
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            cArray[i] = (char)this.randomInt(48, 57);
        }
        return new String(cArray);
    }

    protected String randomCLast(int n) {
        return this.SYLLABLES[n / 100] + this.SYLLABLES[n / 10 % 10] + this.SYLLABLES[n % 10];
    }

    public String randomZIP() {
        return this.randomNString(4, 4) + "11111";
    }

    public int NURand8191() {
        int n = this.randomInt(0, 8191);
        int n2 = this.randomInt(1, 100000);
        int n3 = this.randomInt(0, 8191);
        return ((n | n2) + n3) % 100000 + 1;
    }

    public int NURand1023() {
        int n = this.randomInt(0, 1023);
        int n2 = this.randomInt(1, 3000);
        int n3 = this.randomInt(0, 1023);
        return ((n | n2) + n3) % 3000 + 1;
    }

    public int NURand255() {
        int n = this.randomInt(0, 255);
        int n2 = this.randomInt(0, 999);
        int n3 = this.randomInt(0, 255);
        return ((n | n2) + n3) % 1000 + 0;
    }

    public String randomState() {
        StringBuffer stringBuffer = new StringBuffer(2);
        for (int i = 0; i < 2; ++i) {
            stringBuffer.append((char)this.randomInt(65, 90));
        }
        return stringBuffer.toString();
    }

    public String randomCLastPopulate(int n) {
        if (n <= 1000) {
            return this.randomCLast(n - 1);
        }
        return this.randomCLast(this.NURand255());
    }

    public String randomCLast() {
        return this.randomCLast(this.NURand255());
    }

    public String randomData() {
        String string = this.randomAString26_50();
        if (this.rand.nextDouble() < 0.9) {
            return string;
        }
        int n = this.randomInt(0, string.length() - 9);
        if (n == 0) {
            return "ORIGINAL" + string.substring(8);
        }
        if (n == string.length() - 9) {
            return string.substring(0, string.length() - 9) + "ORIGINAL";
        }
        return string.substring(0, n) + "ORIGINAL" + string.substring(n + 8, string.length());
    }

    public int[] randomIntPerm(int n) {
        int n2;
        int[] nArray = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = n2 + 1;
        }
        for (n2 = 0; n2 < n * 4; ++n2) {
            int n3 = this.randomInt(0, n - 1);
            int n4 = this.randomInt(0, n - 1);
            int n5 = nArray[n3];
            nArray[n3] = nArray[n4];
            nArray[n4] = n5;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAStrings() {
        String[] stringArray = left24;
        synchronized (left24) {
            if (doneInit) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            for (int i = 0; i < 10; ++i) {
                OERandom.left24[i] = this.randomAString(24, 24);
                OERandom.left300[i] = this.randomAString(300, 300);
                OERandom.right200[i] = this.randomAString(0, 200);
                OERandom.left10[i] = this.randomAString(10, 10);
                OERandom.right10[i] = this.randomAString(0, 10);
                OERandom.left14[i] = this.randomAString(10, 10);
                OERandom.left26[i] = this.randomAString(26, 26);
                OERandom.right24[i] = this.randomAString(0, 24);
                OERandom.left8[i] = this.randomAString(8, 8);
                OERandom.right8[i] = this.randomAString(0, 8);
            }
            doneInit = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String randomAString24() {
        return left24[this.randomInt(0, 9)];
    }

    public String randomAString300_500() {
        String string = left300[this.randomInt(0, 9)];
        String string2 = right200[this.randomInt(0, 9)];
        return string.concat(string2);
    }

    public String randomAString10_20() {
        String string = left10[this.randomInt(0, 9)];
        String string2 = right10[this.randomInt(0, 9)];
        return string.concat(string2);
    }

    public String randomAString14_24() {
        String string = left14[this.randomInt(0, 9)];
        String string2 = right10[this.randomInt(0, 9)];
        return string.concat(string2);
    }

    public String randomAString26_50() {
        String string = left26[this.randomInt(0, 9)];
        String string2 = right24[this.randomInt(0, 9)];
        return string.concat(string2);
    }

    public String randomAString8_16() {
        String string = left8[this.randomInt(0, 9)];
        String string2 = right8[this.randomInt(0, 9)];
        return string.concat(string2);
    }
}

