/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.services.T_CacheException;
import org.apache.derbyTesting.unitTests.services.T_CacheUser;
import org.apache.derbyTesting.unitTests.services.T_CachedInteger;
import org.apache.derbyTesting.unitTests.services.T_Key;

public class T_CacheService
extends T_Generic
implements CacheableFactory {
    protected CacheFactory cf;
    protected T_Fail threadFail;

    public Cacheable newCacheable(CacheManager cacheManager) {
        return new T_CachedInteger();
    }

    @Override
    protected void runTests() throws T_Fail {
        DaemonFactory daemonFactory;
        try {
            this.cf = (CacheFactory)T_CacheService.startSystemModule(this.getModuleToTestProtocolName());
            daemonFactory = (DaemonFactory)T_CacheService.startSystemModule("org.apache.derby.iapi.services.daemon.DaemonFactory");
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        if (this.cf == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " module not started.");
        }
        if (daemonFactory == null) {
            throw T_Fail.testFailMsg("org.apache.derby.iapi.services.daemon.DaemonFactory module not started.");
        }
        try {
            DaemonService daemonService = daemonFactory.createNewDaemon("CacheTester");
            if (daemonService == null) {
                throw T_Fail.testFailMsg("Can't create deamon service");
            }
            CacheManager cacheManager = this.cf.newCacheManager((CacheableFactory)this, "testCache1", 20, 40);
            if (cacheManager == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cacheManager, 40);
            cacheManager.useDaemonService(daemonService);
            this.thrashCache(cacheManager, 10, 1000);
            cacheManager.shutdown();
            cacheManager = null;
            CacheManager cacheManager2 = this.cf.newCacheManager((CacheableFactory)this, "testCache2", 0, 1);
            if (cacheManager2 == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cacheManager2, 1);
            cacheManager2.useDaemonService(daemonService);
            this.thrashCache(cacheManager2, 10, 1000);
            cacheManager2.shutdown();
            cacheManager2 = null;
            CacheManager cacheManager3 = this.cf.newCacheManager((CacheableFactory)this, "testCache3", 2000, 40);
            if (cacheManager3 == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cacheManager3, 40);
            cacheManager3.useDaemonService(daemonService);
            this.thrashCache(cacheManager3, 10, 1000);
            cacheManager3.shutdown();
            cacheManager3 = null;
            CacheManager cacheManager4 = this.cf.newCacheManager((CacheableFactory)this, "testCache4", 2000, 40);
            if (cacheManager4 == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cacheManager4, 40);
            this.thrashCache(cacheManager4, 10, 1000);
            cacheManager4.shutdown();
            cacheManager4 = null;
            CacheManager cacheManager5 = this.cf.newCacheManager((CacheableFactory)this, "testCache5", 0, 40);
            if (cacheManager5 == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cacheManager5, 40);
            this.thrashCache(cacheManager5, 10, 1000);
            cacheManager5.shutdown();
            cacheManager5 = null;
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw T_Fail.exceptionFail(throwable);
        }
    }

    @Override
    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.services.cache.CacheFactory";
    }

    protected void T001(CacheManager cacheManager, int n) throws T_Fail, StandardException {
        T_Key t_Key = T_Key.simpleInt(1);
        this.t_findCachedFail(cacheManager, t_Key);
        cacheManager.release(this.t_findSucceed(cacheManager, t_Key));
        cacheManager.release(this.t_findCachedSucceed(cacheManager, t_Key));
        T_Key t_Key2 = T_Key.dontFindInt(2);
        this.t_findCachedFail(cacheManager, t_Key2);
        this.t_findFail(cacheManager, t_Key2);
        cacheManager.release(this.t_findSucceed(cacheManager, t_Key));
        t_Key2 = T_Key.simpleInt(2);
        cacheManager.release(this.t_findSucceed(cacheManager, t_Key2));
        cacheManager.release(this.t_findSucceed(cacheManager, t_Key));
        T_Key t_Key3 = T_Key.exceptionInt(3);
        this.t_findCachedFail(cacheManager, t_Key3);
        try {
            this.t_findFail(cacheManager, t_Key3);
            throw T_Fail.testFailMsg("find call lost user exception");
        }
        catch (StandardException standardException) {
            T_Key t_Key4;
            int n2;
            if (!(standardException instanceof T_CacheException)) {
                throw standardException;
            }
            if (((T_CacheException)standardException).getType() != 2) {
                throw standardException;
            }
            t_Key3 = T_Key.simpleInt(3);
            cacheManager.release(this.t_findSucceed(cacheManager, t_Key3));
            cacheManager.release(this.t_findSucceed(cacheManager, t_Key2));
            cacheManager.release(this.t_findSucceed(cacheManager, t_Key));
            cacheManager.cleanAll();
            cacheManager.ageOut();
            this.t_findCachedFail(cacheManager, t_Key);
            this.t_findCachedFail(cacheManager, t_Key2);
            this.t_findCachedFail(cacheManager, t_Key3);
            for (n2 = 0; n2 < 4 * n; ++n2) {
                t_Key4 = T_Key.simpleInt(n2);
                cacheManager.release(this.t_findSucceed(cacheManager, t_Key4));
                cacheManager.release(this.t_findCachedSucceed(cacheManager, t_Key4));
            }
            cacheManager.cleanAll();
            cacheManager.ageOut();
            for (n2 = 0; n2 < 4 * n; ++n2) {
                t_Key4 = T_Key.simpleInt(n2);
                this.t_findCachedFail(cacheManager, t_Key4);
            }
            Cacheable cacheable = this.t_findSucceed(cacheManager, t_Key);
            if (cacheable == (t_Key4 = this.t_findSucceed(cacheManager, t_Key2))) {
                throw T_Fail.testFailMsg("same object returned for two different keys");
            }
            if (this.t_findSucceed(cacheManager, t_Key) != cacheable) {
                throw T_Fail.testFailMsg("different object returned for same key");
            }
            if (this.t_findSucceed(cacheManager, t_Key2) != t_Key4) {
                throw T_Fail.testFailMsg("different object returned for same key");
            }
            cacheManager.release(cacheable);
            cacheManager.release(cacheable);
            cacheable = null;
            cacheManager.release((Cacheable)t_Key4);
            cacheManager.release((Cacheable)t_Key4);
            t_Key4 = null;
            this.PASS("T001");
            return;
        }
    }

    protected void thrashCache(CacheManager cacheManager, int n, int n2) throws T_Fail {
        int n3;
        Thread[] threadArray = new Thread[n];
        for (n3 = 0; n3 < n; ++n3) {
            threadArray[n3] = new Thread(new T_CacheUser(cacheManager, n2, this, this.out));
        }
        for (n3 = 0; n3 < n; ++n3) {
            threadArray[n3].start();
        }
        try {
            for (n3 = 0; n3 < n; ++n3) {
                if (this.threadFail != null) {
                    throw this.threadFail;
                }
                threadArray[n3].join();
                if (this.threadFail == null) continue;
                throw this.threadFail;
            }
        }
        catch (InterruptedException interruptedException) {
            throw T_Fail.exceptionFail(interruptedException);
        }
        this.PASS("thrashCache");
    }

    public synchronized void setChildException(T_Fail t_Fail) {
        if (this.threadFail == null) {
            this.threadFail = t_Fail;
        }
    }

    protected void t_findCachedFail(CacheManager cacheManager, Object object) throws StandardException, T_Fail {
        Cacheable cacheable = cacheManager.findCached(object);
        if (cacheable != null) {
            throw T_Fail.testFailMsg("found cached item unexpectedly");
        }
    }

    protected Cacheable t_findCachedSucceed(CacheManager cacheManager, Object object) throws StandardException, T_Fail {
        Cacheable cacheable = cacheManager.findCached(object);
        if (cacheable == null) {
            throw T_Fail.testFailMsg("expected item to be in cache");
        }
        if (!cacheable.getIdentity().equals(object)) {
            throw T_Fail.testFailMsg("item returned does not match key");
        }
        return cacheable;
    }

    protected void t_findFail(CacheManager cacheManager, Object object) throws T_Fail, StandardException {
        Cacheable cacheable = cacheManager.find(object);
        if (cacheable != null) {
            throw T_Fail.testFailMsg("found item unexpectedly");
        }
    }

    protected Cacheable t_findSucceed(CacheManager cacheManager, Object object) throws T_Fail, StandardException {
        Cacheable cacheable = cacheManager.find(object);
        if (cacheable == null) {
            throw T_Fail.testFailMsg("expected item to be found");
        }
        if (!cacheable.getIdentity().equals(object)) {
            throw T_Fail.testFailMsg("item returned does not match key");
        }
        return cacheable;
    }

    private static Object startSystemModule(String string) throws StandardException {
        try {
            return Monitor.startSystemModule((String)string);
        }
        catch (Exception exception) {
            throw StandardException.plainWrapException((Throwable)exception);
        }
    }
}

