/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.grails.core.exceptions;

/**
 * Occurs when the creation of a new instance fails.
 *
 * @author Steven Devijver
 */
public class NewInstanceCreationException extends GrailsException {

    private static final long serialVersionUID = -877948309600522419L;

    public NewInstanceCreationException() {
        super();
    }

    public NewInstanceCreationException(String message) {
        super(message);
    }

    public NewInstanceCreationException(String message, Throwable cause) {
        super(message, cause);
    }

    public NewInstanceCreationException(Throwable cause) {
        super(cause);
    }
}
