/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.OperatorRename;
import groovyjarjarasm.asm.Opcodes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.TokenUtil;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class OperatorRenameASTTransformation
extends ClassCodeExpressionTransformer
implements ASTTransformation,
Opcodes {
    private static final Class<OperatorRename> MY_CLASS = OperatorRename.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private SourceUnit sourceUnit;
    private Map<String, String> nameTable = new HashMap<String, String>();

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.sourceUnit = source;
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        this.addIfFound(anno, this.nameTable, "plus");
        this.addIfFound(anno, this.nameTable, "minus");
        this.addIfFound(anno, this.nameTable, "multiply");
        this.addIfFound(anno, this.nameTable, "div");
        this.addIfFound(anno, this.nameTable, "remainder");
        this.addIfFound(anno, this.nameTable, "power");
        this.addIfFound(anno, this.nameTable, "leftShift");
        this.addIfFound(anno, this.nameTable, "rightShift");
        this.addIfFound(anno, this.nameTable, "rightShiftUnsigned");
        this.addIfFound(anno, this.nameTable, "and");
        this.addIfFound(anno, this.nameTable, "or");
        this.addIfFound(anno, this.nameTable, "xor");
        this.addIfFound(anno, this.nameTable, "compareTo");
        if (parent instanceof ClassNode) {
            super.visitClass((ClassNode)parent);
        } else if (parent instanceof ConstructorNode) {
            super.visitConstructorOrMethod((MethodNode)parent, true);
        } else if (parent instanceof MethodNode) {
            super.visitConstructorOrMethod((MethodNode)parent, false);
        }
    }

    private void addIfFound(AnnotationNode anno, Map<String, String> nameTable, String origName) {
        String newName = AbstractASTTransformation.getMemberStringValue(anno, origName);
        if (newName != null) {
            nameTable.put(origName, newName);
        }
    }

    @Override
    public Expression transform(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)expr;
            int type = be.getOperation().getType();
            String oldName = OperatorRenameASTTransformation.getOperationName(type);
            if (this.nameTable.containsKey(oldName)) {
                boolean isEqualOperator = TokenUtil.removeAssignment(type) != type;
                Expression left = this.transform(be.getLeftExpression());
                Expression right = this.transform(be.getRightExpression());
                Expression result = GeneralUtils.callX(left, this.nameTable.get(oldName), right);
                if (isEqualOperator) {
                    result = GeneralUtils.assignX(left, result);
                }
                ((ASTNode)result).setSourcePosition(be);
                return result;
            }
        } else if (expr instanceof ClosureExpression) {
            ClosureExpression ce = (ClosureExpression)expr;
            ce.getCode().visit(this);
        }
        return expr.transformExpression(this);
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    static String getOperationName(int op) {
        switch (op) {
            case 128: {
                return "compareTo";
            }
            case 341: 
            case 351: {
                return "and";
            }
            case 340: 
            case 350: {
                return "or";
            }
            case 342: 
            case 352: {
                return "xor";
            }
            case 200: 
            case 210: {
                return "plus";
            }
            case 201: 
            case 211: {
                return "minus";
            }
            case 202: 
            case 212: {
                return "multiply";
            }
            case 203: 
            case 213: {
                return "div";
            }
            case 353: 
            case 354: {
                return "remainder";
            }
            case 206: 
            case 216: {
                return "power";
            }
            case 280: 
            case 285: {
                return "leftShift";
            }
            case 281: 
            case 286: {
                return "rightShift";
            }
            case 282: 
            case 287: {
                return "rightShiftUnsigned";
            }
        }
        return null;
    }
}

