/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.GammaDistribution;
import org.apache.commons.math.special.Gamma;

public class GammaDistributionImpl
extends AbstractContinuousDistribution
implements GammaDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -3239549463135430361L;
    private double alpha;
    private double beta;
    private final double solverAbsoluteAccuracy;

    public GammaDistributionImpl(double alpha, double beta) {
        this(alpha, beta, 1.0E-9);
    }

    public GammaDistributionImpl(double alpha, double beta, double inverseCumAccuracy) {
        this.setAlphaInternal(alpha);
        this.setBetaInternal(beta);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public double cumulativeProbability(double x) throws MathException {
        double ret = x <= 0.0 ? 0.0 : Gamma.regularizedGammaP(this.alpha, x / this.beta);
        return ret;
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    @Deprecated
    public void setAlpha(double alpha) {
        this.setAlphaInternal(alpha);
    }

    private void setAlphaInternal(double newAlpha) {
        if (newAlpha <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("alpha must be positive ({0})", newAlpha);
        }
        this.alpha = newAlpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    @Deprecated
    public void setBeta(double newBeta) {
        this.setBetaInternal(newBeta);
    }

    private void setBetaInternal(double newBeta) {
        if (newBeta <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("beta must be positive ({0})", newBeta);
        }
        this.beta = newBeta;
    }

    public double getBeta() {
        return this.beta;
    }

    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return Math.pow(x / this.beta, this.alpha - 1.0) / this.beta * Math.exp(-x / this.beta) / Math.exp(Gamma.logGamma(this.alpha));
    }

    public double density(Double x) {
        return this.density((double)x);
    }

    protected double getDomainLowerBound(double p) {
        return Double.MIN_VALUE;
    }

    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.alpha * this.beta : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.alpha * this.beta * 0.5 : this.alpha * this.beta;
        return ret;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

