/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.helix.cloud.event.AbstractEventHandler;
import org.apache.helix.cloud.event.CloudEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventHandler
implements AbstractEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)CloudEventHandler.class.getName());
    private List<CloudEventListener> _unorderedEventListenerList = new ArrayList<CloudEventListener>();
    private Optional<CloudEventListener> _preEventHandlerCallback = Optional.empty();
    private Optional<CloudEventListener> _postEventHandlerCallback = Optional.empty();

    @Override
    public void registerCloudEventListener(CloudEventListener listener) {
        if (listener != null) {
            switch (listener.getListenerType()) {
                case PRE_EVENT_HANDLER: {
                    this._preEventHandlerCallback = Optional.of(listener);
                    break;
                }
                case POST_EVENT_HANDLER: {
                    this._postEventHandlerCallback = Optional.of(listener);
                    break;
                }
                default: {
                    this._unorderedEventListenerList.add(listener);
                }
            }
        }
    }

    @Override
    public void unregisterCloudEventListener(CloudEventListener listener) {
        this._unorderedEventListenerList.remove(listener);
    }

    public void performAction(Object eventType, Object eventInfo) {
        this._preEventHandlerCallback.ifPresent(callback -> callback.performAction(eventType, eventInfo));
        this._unorderedEventListenerList.parallelStream().forEach(listener -> listener.performAction(eventType, eventInfo));
        this._postEventHandlerCallback.ifPresent(callback -> callback.performAction(eventType, eventInfo));
    }
}

