/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

abstract class SoftConstraint {
    private final double _maxScore;
    private final double _minScore;

    SoftConstraint(double maxScore, double minScore) {
        this._maxScore = maxScore;
        this._minScore = minScore;
    }

    protected double getMaxScore() {
        return this._maxScore;
    }

    protected double getMinScore() {
        return this._minScore;
    }

    protected abstract double getAssignmentScore(AssignableNode var1, AssignableReplica var2, ClusterContext var3);

    double getAssignmentNormalizedScore(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        return this.getNormalizeFunction().scale(this.getAssignmentScore(node, replica, clusterContext));
    }

    protected NormalizeFunction getNormalizeFunction() {
        return score -> (score - this.getMinScore()) / (this.getMaxScore() - this.getMinScore());
    }

    static interface NormalizeFunction {
        public double scale(double var1);
    }
}

