/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public final class OnlineOfflineSMD
extends StateModelDefinition {
    public static final String name = "OnlineOffline";

    public OnlineOfflineSMD() {
        super(OnlineOfflineSMD.generateConfigForOnlineOffline());
    }

    public static StateModelDefinition build() {
        StateModelDefinition.Builder builder = new StateModelDefinition.Builder(name);
        builder.initialState(States.OFFLINE.name());
        builder.addState(States.ONLINE.name(), 0);
        builder.addState(States.OFFLINE.name(), 1);
        for (HelixDefinedState state : HelixDefinedState.values()) {
            builder.addState(state.name());
        }
        builder.addTransition(States.ONLINE.name(), States.OFFLINE.name(), 0);
        builder.addTransition(States.OFFLINE.name(), States.ONLINE.name(), 1);
        builder.addTransition(States.OFFLINE.name(), HelixDefinedState.DROPPED.name());
        builder.dynamicUpperBound(States.ONLINE.name(), "R");
        return builder.build();
    }

    @Deprecated
    public static ZNRecord generateConfigForOnlineOffline() {
        HashMap<String, String> metadata;
        String key;
        ZNRecord record = new ZNRecord(name);
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), "OFFLINE");
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add("ONLINE");
        statePriorityList.add("OFFLINE");
        statePriorityList.add("DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            key = state + ".meta";
            metadata = new HashMap<String, String>();
            if (state.equals("ONLINE")) {
                metadata.put("count", "R");
                record.setMapField(key, metadata);
            }
            if (state.equals("OFFLINE")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
            }
            if (!state.equals("DROPPED")) continue;
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        for (String state : statePriorityList) {
            key = state + ".next";
            if (state.equals("ONLINE")) {
                metadata = new HashMap();
                metadata.put("OFFLINE", "OFFLINE");
                metadata.put("DROPPED", "OFFLINE");
                record.setMapField(key, metadata);
            }
            if (!state.equals("OFFLINE")) continue;
            metadata = new HashMap();
            metadata.put("ONLINE", "ONLINE");
            metadata.put("DROPPED", "DROPPED");
            record.setMapField(key, metadata);
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add("OFFLINE-ONLINE");
        stateTransitionPriorityList.add("ONLINE-OFFLINE");
        stateTransitionPriorityList.add("OFFLINE-DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        return record;
    }

    public static enum States {
        ONLINE,
        OFFLINE;

    }
}

