/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedViewMonitor
extends DynamicMBeanProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CustomizedViewMonitor.class);
    private static final String MBEAN_DESCRIPTION = "Helix Customized View Aggregation Monitor";
    private final String _clusterName;
    private final String _sensorName;
    private HistogramDynamicMetric _updateToAggregationLatencyGauge;
    public static final String UPDATE_TO_AGGREGATION_LATENCY_GAUGE = "UpdateToAggregationLatencyGauge";
    private static final String TYPE_KEY = "Type";
    private static final String CLUSTER_KEY = "Cluster";
    private static final String CUSTOMIZED_VIEW = "CustomizedView";

    public CustomizedViewMonitor(String clusterName) {
        this._clusterName = clusterName;
        this._sensorName = String.format("%s.%s.%s", MonitorDomainNames.AggregatedView.name(), CUSTOMIZED_VIEW, this._clusterName);
        this._updateToAggregationLatencyGauge = new HistogramDynamicMetric(UPDATE_TO_AGGREGATION_LATENCY_GAUGE, new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._updateToAggregationLatencyGauge);
        this.doRegister(attributeList, MBEAN_DESCRIPTION, this.getMBeanObjectName());
        return this;
    }

    private ObjectName getMBeanObjectName() throws MalformedObjectNameException {
        return new ObjectName(String.format("%s:%s=%s,%s=%s", MonitorDomainNames.AggregatedView.name(), TYPE_KEY, CUSTOMIZED_VIEW, CLUSTER_KEY, this._clusterName));
    }

    @Override
    public String getSensorName() {
        return this._sensorName;
    }

    public void recordUpdateToAggregationLatency(long latency) {
        this._updateToAggregationLatencyGauge.updateValue(latency);
    }
}

