/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import org.apache.ignite.internal.util.GridUnsafe;

public abstract class BinaryPrimitives {
    public static void writeByte(byte[] arr, int off, byte val) {
        GridUnsafe.putByte(arr, GridUnsafe.BYTE_ARR_OFF + (long)off, val);
    }

    public static byte readByte(byte[] arr, int off) {
        return GridUnsafe.getByte(arr, GridUnsafe.BYTE_ARR_OFF + (long)off);
    }

    public static byte readByte(long ptr, int off) {
        return GridUnsafe.getByte(ptr + (long)off);
    }

    public static byte[] readByteArray(byte[] arr, int off, int len) {
        byte[] arr0 = new byte[len];
        System.arraycopy(arr, off, arr0, 0, len);
        return arr0;
    }

    public static byte[] readByteArray(long ptr, int off, int len) {
        byte[] arr0 = new byte[len];
        GridUnsafe.copyOffheapHeap(ptr + (long)off, arr0, GridUnsafe.BYTE_ARR_OFF, len);
        return arr0;
    }

    public static void writeBoolean(byte[] arr, int off, boolean val) {
        BinaryPrimitives.writeByte(arr, off, val ? (byte)1 : 0);
    }

    public static boolean readBoolean(byte[] arr, int off) {
        return BinaryPrimitives.readByte(arr, off) == 1;
    }

    public static boolean readBoolean(long ptr, int off) {
        return BinaryPrimitives.readByte(ptr, off) == 1;
    }

    public static void writeShort(byte[] arr, int off, short val) {
        long pos = GridUnsafe.BYTE_ARR_OFF + (long)off;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putShortLE(arr, pos, val);
        } else {
            GridUnsafe.putShort(arr, pos, val);
        }
    }

    public static void writeShort(long ptr, int off, short val) {
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putShortLE(ptr + (long)off, val);
        } else {
            GridUnsafe.putShort(ptr + (long)off, val);
        }
    }

    public static short readShort(byte[] arr, int off) {
        long pos = GridUnsafe.BYTE_ARR_OFF + (long)off;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getShortLE(arr, pos) : GridUnsafe.getShort(arr, pos);
    }

    public static short readShort(long ptr, int off) {
        long addr = ptr + (long)off;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getShortLE(addr) : GridUnsafe.getShort(addr);
    }

    public static void writeChar(byte[] arr, int off, char val) {
        long pos = GridUnsafe.BYTE_ARR_OFF + (long)off;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putCharLE(arr, pos, val);
        } else {
            GridUnsafe.putChar(arr, pos, val);
        }
    }

    public static char readChar(byte[] arr, int off) {
        long pos = GridUnsafe.BYTE_ARR_OFF + (long)off;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getCharLE(arr, pos) : GridUnsafe.getChar(arr, pos);
    }

    public static char readChar(long ptr, int off) {
        long addr = ptr + (long)off;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getCharLE(addr) : GridUnsafe.getChar(addr);
    }

    public static char[] readCharArray(byte[] arr, int off, int len) {
        char[] arr0 = new char[len];
        GridUnsafe.copyMemory(arr, GridUnsafe.BYTE_ARR_OFF + (long)off, arr0, GridUnsafe.CHAR_ARR_OFF, len << 1);
        if (GridUnsafe.BIG_ENDIAN) {
            for (int i = 0; i < len; ++i) {
                arr0[i] = Character.reverseBytes(arr0[i]);
            }
        }
        return arr0;
    }

    public static char[] readCharArray(long ptr, int off, int len) {
        char[] arr0 = new char[len];
        GridUnsafe.copyOffheapHeap(ptr + (long)off, arr0, GridUnsafe.CHAR_ARR_OFF, len << 1);
        if (GridUnsafe.BIG_ENDIAN) {
            for (int i = 0; i < len; ++i) {
                arr0[i] = Character.reverseBytes(arr0[i]);
            }
        }
        return arr0;
    }

    public static void writeInt(byte[] arr, int off, int val) {
        long pos = GridUnsafe.BYTE_ARR_OFF + (long)off;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putIntLE(arr, pos, val);
        } else {
            GridUnsafe.putInt(arr, pos, val);
        }
    }

    public static void writeInt(long ptr, int off, int val) {
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putIntLE(ptr + (long)off, val);
        } else {
            GridUnsafe.putInt(ptr + (long)off, val);
        }
    }

    public static int readInt(byte[] arr, int off) {
        long pos = GridUnsafe.BYTE_ARR_OFF + (long)off;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getIntLE(arr, pos) : GridUnsafe.getInt(arr, pos);
    }

    public static int readInt(long ptr, int off) {
        long addr = ptr + (long)off;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getIntLE(addr) : GridUnsafe.getInt(addr);
    }

    public static void writeLong(byte[] arr, int off, long val) {
        long pos = GridUnsafe.BYTE_ARR_OFF + (long)off;
        if (GridUnsafe.BIG_ENDIAN) {
            GridUnsafe.putLongLE(arr, pos, val);
        } else {
            GridUnsafe.putLong(arr, pos, val);
        }
    }

    public static long readLong(byte[] arr, int off) {
        long pos = GridUnsafe.BYTE_ARR_OFF + (long)off;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getLongLE(arr, pos) : GridUnsafe.getLong(arr, pos);
    }

    public static long readLong(long ptr, int off) {
        long addr = ptr + (long)off;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getLongLE(addr) : GridUnsafe.getLong(addr);
    }

    public static void writeFloat(byte[] arr, int off, float val) {
        int val0 = Float.floatToIntBits(val);
        BinaryPrimitives.writeInt(arr, off, val0);
    }

    public static float readFloat(byte[] arr, int off) {
        int val = BinaryPrimitives.readInt(arr, off);
        return Float.intBitsToFloat(val);
    }

    public static float readFloat(long ptr, int off) {
        int val = BinaryPrimitives.readInt(ptr, off);
        return Float.intBitsToFloat(val);
    }

    public static void writeDouble(byte[] arr, int off, double val) {
        long val0 = Double.doubleToLongBits(val);
        BinaryPrimitives.writeLong(arr, off, val0);
    }

    public static double readDouble(byte[] arr, int off) {
        long val = BinaryPrimitives.readLong(arr, off);
        return Double.longBitsToDouble(val);
    }

    public static double readDouble(long ptr, int off) {
        long val = BinaryPrimitives.readLong(ptr, off);
        return Double.longBitsToDouble(val);
    }
}

