/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.task;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.TaskState;
import org.apache.ignite.internal.compute.CancellableTaskExecution;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.compute.task.TaskExecutionInternal;
import org.apache.ignite.marshalling.Marshaller;
import org.jetbrains.annotations.Nullable;

public class DelegatingTaskExecution<I, M, T, R>
implements CancellableTaskExecution<R>,
MarshallerProvider<R> {
    private final CompletableFuture<TaskExecutionInternal<I, M, T, R>> delegate;

    public DelegatingTaskExecution(CompletableFuture<TaskExecutionInternal<I, M, T, R>> delegate) {
        this.delegate = delegate;
    }

    public CompletableFuture<R> resultAsync() {
        return this.delegate.thenCompose(TaskExecutionInternal::resultAsync);
    }

    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        return this.delegate.thenCompose(TaskExecutionInternal::statesAsync);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        return this.delegate.thenCompose(TaskExecutionInternal::cancelAsync);
    }

    public CompletableFuture<@Nullable TaskState> stateAsync() {
        return this.delegate.thenCompose(TaskExecutionInternal::stateAsync);
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.delegate.thenCompose(execution -> execution.changePriorityAsync(newPriority));
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        assert (this.delegate.isDone()) : "Task execution is supposed to be done before calling `resultMarshaller()`";
        return this.delegate.join().resultMarshaller();
    }

    @Override
    public boolean marshalResult() {
        assert (this.delegate.isDone()) : "Task execution is supposed to be done before calling `marshalResult()`";
        return this.delegate.join().marshalResult();
    }
}

