/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.binary;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.ClientStringResponse;

public class ClientBinaryTypeNameGetRequest
extends ClientRequest {
    private final byte platformId;
    private final int typeId;

    public ClientBinaryTypeNameGetRequest(BinaryRawReader reader) {
        super(reader);
        this.platformId = reader.readByte();
        this.typeId = reader.readInt();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        try {
            String typeName = ctx.kernalContext().marshallerContext().getClassName(this.platformId, this.typeId);
            return new ClientStringResponse(this.requestId(), typeName);
        }
        catch (ClassNotFoundException | IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }
}

