/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.partition.replicator.raft.PartitionSnapshotInfo;
import org.apache.ignite3.internal.partition.replicator.raft.PartitionSnapshotInfoSerializer;
import org.apache.ignite3.internal.partition.replicator.raft.RaftTableProcessor;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;
import org.apache.ignite3.internal.versioned.VersionedSerialization;

public class OnSnapshotSaveHandler {
    private final TxStatePartitionStorage txStatePartitionStorage;
    private final Executor partitionOperationsExecutor;

    public OnSnapshotSaveHandler(TxStatePartitionStorage txStatePartitionStorage, Executor partitionOperationsExecutor) {
        this.txStatePartitionStorage = txStatePartitionStorage;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
    }

    public CompletableFuture<Void> onSnapshotSave(PartitionSnapshotInfo snapshotInfo, Collection<RaftTableProcessor> tableProcessors) {
        long lastAppliedIndex = snapshotInfo.lastAppliedIndex();
        long lastAppliedTerm = snapshotInfo.lastAppliedTerm();
        tableProcessors.forEach(processor -> processor.lastApplied(lastAppliedIndex, lastAppliedTerm));
        this.txStatePartitionStorage.lastApplied(lastAppliedIndex, lastAppliedTerm);
        CompletableFuture[] tableStorageFlushFutures = (CompletableFuture[])tableProcessors.stream().map(RaftTableProcessor::flushStorage).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(tableStorageFlushFutures).thenComposeAsync(v -> {
            byte[] snapshotInfoBytes = VersionedSerialization.toBytes(snapshotInfo, PartitionSnapshotInfoSerializer.INSTANCE);
            this.txStatePartitionStorage.snapshotInfo(snapshotInfoBytes);
            return this.txStatePartitionStorage.flush();
        }, this.partitionOperationsExecutor);
    }
}

