/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public enum ViewType {
    BASE(0),
    VIEW(1);

    private final byte type;

    private ViewType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public static ViewType deserialize(byte type) {
        return ViewType.getViewType(type);
    }

    public static ViewType deserializeFrom(ByteBuffer buffer) {
        return ViewType.deserialize(buffer.get());
    }

    public void serializeTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.getType());
    }

    public void serializeTo(DataOutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
    }

    public static ViewType getViewType(byte type) {
        switch (type) {
            case 0: {
                return BASE;
            }
            case 1: {
                return VIEW;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }
}

