/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.auth.BasicCredentialsProvider;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemInitializationContext;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;

public interface SftpFileSystemClientSessionInitializer {
    public static final SftpFileSystemClientSessionInitializer DEFAULT = new SftpFileSystemClientSessionInitializer(){

        public String toString() {
            return SftpFileSystemClientSessionInitializer.class.getSimpleName() + "[DEFAULT]";
        }
    };

    default public ClientSession createClientSession(SftpFileSystemProvider provider, SftpFileSystemInitializationContext context) throws IOException {
        BasicCredentialsProvider user = context.getCredentials();
        SshClient client = provider.getClientInstance();
        return (ClientSession)((ConnectFuture)client.connect(user.getUsername(), context.getHost(), context.getPort()).verify(context.getMaxConnectTime(), new CancelOption[0])).getSession();
    }

    default public void authenticateClientSession(SftpFileSystemProvider provider, SftpFileSystemInitializationContext context, ClientSession session) throws IOException {
        BasicCredentialsProvider passwordHolder = context.getCredentials();
        String password = passwordHolder.getPassword();
        if (password != null) {
            session.addPasswordIdentity(password);
        }
        session.auth().verify(context.getMaxAuthTime(), new CancelOption[0]);
    }

    default public SftpFileSystem createSftpFileSystem(SftpFileSystemProvider provider, SftpFileSystemInitializationContext context, ClientSession session, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        return new SftpFileSystem(provider, context.getId(), session, provider.getSftpClientFactory(), selector, errorDataHandler);
    }
}

