/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.configurator.impl.ConfigUtil;
import org.apache.felix.configurator.impl.CoordinatorUtil;
import org.apache.felix.configurator.impl.Util;
import org.apache.felix.configurator.impl.WorkerQueue;
import org.apache.felix.configurator.impl.json.BinUtil;
import org.apache.felix.configurator.impl.json.BinaryManager;
import org.apache.felix.configurator.impl.json.JSONUtil;
import org.apache.felix.configurator.impl.logger.SystemLogger;
import org.apache.felix.configurator.impl.model.AbstractState;
import org.apache.felix.configurator.impl.model.BundleState;
import org.apache.felix.configurator.impl.model.Config;
import org.apache.felix.configurator.impl.model.ConfigList;
import org.apache.felix.configurator.impl.model.ConfigPolicy;
import org.apache.felix.configurator.impl.model.ConfigState;
import org.apache.felix.configurator.impl.model.ConfigurationFile;
import org.apache.felix.configurator.impl.model.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class Configurator {
    private final BundleContext bundleContext;
    private final State state;
    private final BundleTracker<Bundle> tracker;
    private volatile boolean active = true;
    private volatile Object coordinator;
    private final WorkerQueue queue = new WorkerQueue();
    private final List<ServiceReference<ConfigurationAdmin>> configAdminReferences;

    public Configurator(BundleContext bc, List<ServiceReference<ConfigurationAdmin>> configAdminReferences) {
        this.bundleContext = bc;
        this.configAdminReferences = configAdminReferences;
        State s = null;
        try {
            s = State.createOrReadState(this.bundleContext.getDataFile("state.ser"));
        }
        catch (IOException | ClassNotFoundException e) {
            SystemLogger.error("Unable to read persisted state from state.ser", e);
            s = new State();
        }
        this.state = s;
        this.tracker = new BundleTracker(this.bundleContext, 62, (BundleTrackerCustomizer)new BundleTrackerCustomizer<Bundle>(){

            public Bundle addingBundle(final Bundle bundle, BundleEvent event) {
                int state = bundle.getState();
                if (Configurator.this.active && (state == 32 || state == 8)) {
                    SystemLogger.debug("Adding bundle " + Configurator.this.getBundleIdentity(bundle) + " : " + Configurator.this.getBundleState(state));
                    Configurator.this.queue.enqueue(new Runnable(){

                        @Override
                        public void run() {
                            if (Configurator.this.processAddBundle(bundle)) {
                                Configurator.this.process();
                            }
                        }
                    });
                }
                return bundle;
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
                this.addingBundle(bundle, event);
            }

            public void removedBundle(final Bundle bundle, BundleEvent event, Bundle object) {
                int state = bundle.getState();
                if (Configurator.this.active && state == 1) {
                    SystemLogger.debug("Removing bundle " + Configurator.this.getBundleIdentity(bundle) + " : " + Configurator.this.getBundleState(state));
                    Configurator.this.queue.enqueue(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (Configurator.this.processRemoveBundle(bundle.getBundleId())) {
                                    Configurator.this.process();
                                }
                            }
                            catch (IllegalStateException ise) {
                                SystemLogger.error("Error processing bundle " + Configurator.this.getBundleIdentity(bundle), ise);
                            }
                        }
                    });
                }
            }
        });
    }

    public void configAdminAdded() {
        this.queue.enqueue(new Runnable(){

            @Override
            public void run() {
                Configurator.this.process();
            }
        });
    }

    private String getBundleIdentity(Bundle bundle) {
        if (bundle.getSymbolicName() == null) {
            return bundle.getBundleId() + " (" + bundle.getLocation() + ")";
        }
        return bundle.getSymbolicName() + ":" + bundle.getVersion() + " (" + bundle.getBundleId() + ")";
    }

    private String getBundleState(int state) {
        switch (state) {
            case 32: {
                return "active";
            }
            case 2: {
                return "installed";
            }
            case 4: {
                return "resolved";
            }
            case 8: {
                return "starting";
            }
            case 16: {
                return "stopping";
            }
            case 1: {
                return "uninstalled";
            }
        }
        return String.valueOf(state);
    }

    public void shutdown() {
        this.active = false;
        this.queue.stop();
        this.tracker.close();
    }

    public void start() {
        String initial;
        String dirPath = this.bundleContext.getProperty("configurator.binaries");
        if (dirPath != null) {
            File dir = new File(dirPath);
            if (dir.exists() && dir.isDirectory()) {
                BinUtil.binDirectory = dir;
            } else if (dir.exists()) {
                SystemLogger.error("Directory property is pointing at a file not a dir: " + dirPath + ". Using default path.");
            } else {
                try {
                    if (dir.mkdirs()) {
                        BinUtil.binDirectory = dir;
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (BinUtil.binDirectory == null) {
                    SystemLogger.error("Unable to create a directory at: " + dirPath + ". Using default path.");
                }
            }
        }
        if (BinUtil.binDirectory == null) {
            BinUtil.binDirectory = this.bundleContext.getDataFile("binaries" + File.separatorChar + ".check");
            BinUtil.binDirectory = BinUtil.binDirectory.getParentFile();
            BinUtil.binDirectory.mkdirs();
        }
        if ((initial = this.bundleContext.getProperty("configurator.initial")) == null) {
            this.processRemoveBundle(-1L);
        } else {
            HashSet<String> hashes = new HashSet<String>();
            TreeMap<String, String> files = new TreeMap<String, String>();
            if (!initial.trim().startsWith("{")) {
                String[] urls;
                String[] stringArray = urls = initial.trim().split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    URL url = null;
                    try {
                        url = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (url == null) continue;
                    try {
                        String contents = JSONUtil.getResource(string, url);
                        files.put(string, contents);
                        hashes.add(Util.getSHA256(contents.trim()));
                        continue;
                    }
                    catch (IOException ioe) {
                        SystemLogger.error("Unable to read " + string, ioe);
                    }
                }
            } else {
                hashes.add(Util.getSHA256(initial.trim()));
                files.put("configurator.initial", initial);
            }
            if (this.state.getInitialHashes() == null || !this.state.getInitialHashes().equals(hashes)) {
                if (this.state.getInitialHashes() != null) {
                    this.processRemoveBundle(-1L);
                }
                JSONUtil.Report report = new JSONUtil.Report();
                BinaryManager converter = new BinaryManager(null, report);
                ArrayList<ConfigurationFile> allFiles = new ArrayList<ConfigurationFile>();
                for (Map.Entry entry : files.entrySet()) {
                    ConfigurationFile file = JSONUtil.readJSON(converter, (String)entry.getKey(), null, -1L, (String)entry.getValue(), report);
                    if (file == null) continue;
                    allFiles.add(file);
                }
                for (String string : report.warnings) {
                    SystemLogger.warning(string);
                }
                for (String string : report.errors) {
                    SystemLogger.error(string);
                }
                BundleState bState = new BundleState();
                bState.addFiles(allFiles);
                for (String pid : bState.getPids()) {
                    this.state.addAll(pid, bState.getConfigurations(pid));
                }
                this.state.setInitialHashes(hashes);
            }
        }
        Bundle[] bundles = this.bundleContext.getBundles();
        HashSet<Long> ids = new HashSet<Long>();
        for (Bundle b : bundles) {
            ids.add(b.getBundleId());
            int n = b.getState();
            if (n != 32 && n != 8) continue;
            this.processAddBundle(b);
        }
        Iterator<Long> iterator = new HashSet<Long>(this.state.getKnownBundleIds()).iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            if (ids.contains(id)) continue;
            this.processRemoveBundle(id);
        }
        this.process();
        this.tracker.open();
    }

    public boolean processAddBundle(final Bundle bundle) {
        long bundleId = bundle.getBundleId();
        long bundleLastModified = bundle.getLastModified();
        Long lastModified = this.state.getLastModified(bundleId);
        if (lastModified != null && lastModified == bundleLastModified) {
            return false;
        }
        AbstractState config = null;
        try {
            Set<String> paths = Util.isConfigurerBundle(bundle, this.bundleContext.getBundle().getBundleId());
            if (paths != null) {
                JSONUtil.Report report = new JSONUtil.Report();
                config = JSONUtil.readConfigurationsFromBundle(new BinUtil.ResourceProvider(){

                    @Override
                    public String getIdentifier() {
                        return bundle.toString();
                    }

                    @Override
                    public URL getEntry(String path) {
                        return bundle.getEntry(path);
                    }

                    @Override
                    public long getBundleId() {
                        return bundle.getBundleId();
                    }

                    @Override
                    public Enumeration<URL> findEntries(String path, String filePattern) {
                        return bundle.findEntries(path, filePattern, false);
                    }
                }, paths, report);
                for (String w : report.warnings) {
                    SystemLogger.warning(w);
                }
                for (String e : report.errors) {
                    SystemLogger.error(e);
                }
            }
        }
        catch (IllegalStateException ise) {
            SystemLogger.error("Error processing bundle " + this.getBundleIdentity(bundle), ise);
        }
        if (lastModified != null) {
            this.processRemoveBundle(bundleId);
        }
        if (config != null) {
            for (String pid : config.getPids()) {
                this.state.addAll(pid, config.getConfigurations(pid));
            }
            this.state.setLastModified(bundleId, bundleLastModified);
            return true;
        }
        return lastModified != null;
    }

    public boolean processRemoveBundle(long bundleId) {
        if (this.state.getLastModified(bundleId) != null) {
            this.state.removeLastModified(bundleId);
            for (String pid : this.state.getPids()) {
                ConfigList configList = this.state.getConfigurations(pid);
                configList.uninstall(bundleId);
            }
            return true;
        }
        return false;
    }

    public void setCoordinator(Object coordinator) {
        this.coordinator = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Object localCoordinator = this.coordinator;
        Object coordination = null;
        if (localCoordinator != null) {
            coordination = CoordinatorUtil.getCoordination(localCoordinator);
        }
        boolean retry = false;
        try {
            for (String string : this.state.getPids()) {
                ConfigList configList = this.state.getConfigurations(string);
                if (!configList.hasChanges()) continue;
                if (this.process(configList)) {
                    try {
                        State.writeState(this.bundleContext.getDataFile("state.ser"), this.state);
                    }
                    catch (IOException ioe) {
                        SystemLogger.error("Unable to persist state to state.ser", ioe);
                    }
                    continue;
                }
                retry = true;
            }
        }
        finally {
            if (coordination != null) {
                CoordinatorUtil.endCoordination(coordination);
            }
        }
        if (!retry) {
            boolean changed = false;
            for (Long bundleId : this.state.getBundleIdsUsingConfigAdmin()) {
                if (this.state.getLastModified(bundleId) != null) continue;
                this.state.removeConfigAdminBundleId(bundleId);
                changed = true;
            }
            if (changed) {
                try {
                    State.writeState(this.bundleContext.getDataFile("state.ser"), this.state);
                }
                catch (IOException iOException) {
                    SystemLogger.error("Unable to persist state to state.ser", iOException);
                }
            }
        }
    }

    public boolean process(ConfigList configList) {
        Config toActivate = null;
        Config toDeactivate = null;
        for (Config cfg : configList) {
            switch (cfg.getState()) {
                case INSTALL: {
                    if (toActivate != null) break;
                    toActivate = cfg;
                    break;
                }
                case IGNORED: 
                case INSTALLED: {
                    if (toActivate == null) {
                        toActivate = cfg;
                        break;
                    }
                    cfg.setState(ConfigState.INSTALL);
                    break;
                }
                case UNINSTALL: {
                    if (toDeactivate != null) break;
                    toDeactivate = cfg;
                    break;
                }
            }
        }
        boolean noRetryNeeded = true;
        if (toActivate != null && toActivate.getState() == ConfigState.INSTALL) {
            noRetryNeeded = this.activate(configList, toActivate);
        }
        if (toActivate == null && toDeactivate != null) {
            noRetryNeeded = this.deactivate(configList, toDeactivate);
        }
        if (noRetryNeeded) {
            Iterator<Config> iter = configList.iterator();
            boolean foundInstalled = false;
            while (iter.hasNext()) {
                Config cfg = iter.next();
                if (cfg.getState() == ConfigState.UNINSTALL || cfg.getState() == ConfigState.UNINSTALLED) {
                    if (cfg.getFiles() != null) {
                        for (File f : cfg.getFiles()) {
                            f.delete();
                        }
                    }
                    iter.remove();
                    continue;
                }
                if (cfg.getState() != ConfigState.INSTALLED) continue;
                if (foundInstalled) {
                    cfg.setState(ConfigState.INSTALL);
                    continue;
                }
                foundInstalled = true;
            }
            configList.setHasChanges(false);
        }
        return noRetryNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationAdmin getConfigurationAdmin(long configAdminServiceBundleId) {
        ServiceReference<ConfigurationAdmin> ref = null;
        List<ServiceReference<ConfigurationAdmin>> list = this.configAdminReferences;
        synchronized (list) {
            for (ServiceReference<ConfigurationAdmin> r : this.configAdminReferences) {
                Bundle bundle = r.getBundle();
                if (bundle == null || bundle.getBundleId() != configAdminServiceBundleId) continue;
                ref = r;
                break;
            }
        }
        if (ref != null) {
            return (ConfigurationAdmin)this.bundleContext.getService(ref);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(ConfigList configList, Config cfg) {
        Long configAdminServiceBundleId;
        block22: {
            configAdminServiceBundleId = this.state.getConfigAdminBundleId(cfg.getBundleId());
            if (configAdminServiceBundleId == null) {
                Bundle configBundle;
                Bundle bundle = configBundle = cfg.getBundleId() == -1L ? this.bundleContext.getBundle() : this.bundleContext.getBundle("System Bundle").getBundleContext().getBundle(cfg.getBundleId());
                if (!(configBundle == null || configBundle.getState() != 8 && configBundle.getState() != 32 || System.getSecurityManager() != null && !configBundle.hasPermission((Object)new ServicePermission(ConfigurationAdmin.class.getName(), "get")))) {
                    try {
                        BundleContext ctx = configBundle.getBundleContext();
                        if (ctx == null) break block22;
                        Collection refs = ctx.getServiceReferences(ConfigurationAdmin.class, null);
                        ArrayList sortedRefs = new ArrayList(refs);
                        Collections.sort(sortedRefs);
                        for (int i = sortedRefs.size(); i > 0; --i) {
                            ServiceReference r = (ServiceReference)sortedRefs.get(i - 1);
                            List<ServiceReference<ConfigurationAdmin>> list = this.configAdminReferences;
                            synchronized (list) {
                                if (this.configAdminReferences.contains(r)) {
                                    configAdminServiceBundleId = r.getBundle().getBundleId();
                                    break;
                                }
                                continue;
                            }
                        }
                    }
                    catch (IllegalStateException ctx) {
                    }
                    catch (InvalidSyntaxException ctx) {
                        // empty catch block
                    }
                }
            }
        }
        if (configAdminServiceBundleId == null) {
            return false;
        }
        ConfigurationAdmin configAdmin = this.getConfigurationAdmin(configAdminServiceBundleId);
        if (configAdmin == null) {
            return false;
        }
        this.state.setConfigAdminBundleId(cfg.getBundleId(), configAdminServiceBundleId);
        boolean ignore = false;
        try {
            boolean update = false;
            Configuration configuration = ConfigUtil.getOrCreateConfiguration(configAdmin, cfg.getPid(), false);
            if (configuration == null) {
                configuration = ConfigUtil.getOrCreateConfiguration(configAdmin, cfg.getPid(), true);
                update = true;
            } else if (cfg.getPolicy() == ConfigPolicy.FORCE) {
                update = true;
            } else if (configList.getLastInstalled() == null || configList.getChangeCount() != configuration.getChangeCount()) {
                ignore = true;
            } else {
                update = true;
            }
            if (update) {
                configuration.updateIfDifferent(cfg.getProperties());
                cfg.setState(ConfigState.INSTALLED);
                configList.setChangeCount(configuration.getChangeCount());
                configList.setLastInstalled(cfg);
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            SystemLogger.error("Unable to update configuration " + cfg.getPid() + " : " + e.getMessage(), e);
            ignore = true;
        }
        if (ignore) {
            cfg.setState(ConfigState.IGNORED);
            configList.setChangeCount(-1L);
            configList.setLastInstalled(null);
        }
        return true;
    }

    public boolean deactivate(ConfigList configList, Config cfg) {
        Bundle configBundle;
        Long configAdminServiceBundleId = this.state.getConfigAdminBundleId(cfg.getBundleId());
        Bundle bundle = configBundle = configAdminServiceBundleId == null ? null : this.bundleContext.getBundle("System Bundle").getBundleContext().getBundle(configAdminServiceBundleId.longValue());
        if (configBundle != null) {
            ConfigurationAdmin configAdmin = this.getConfigurationAdmin(configAdminServiceBundleId);
            if (configAdmin == null) {
                return false;
            }
            try {
                Configuration c = ConfigUtil.getOrCreateConfiguration(configAdmin, cfg.getPid(), false);
                if (c != null && (cfg.getPolicy() == ConfigPolicy.FORCE || configList.getChangeCount() == c.getChangeCount())) {
                    c.delete();
                }
            }
            catch (IOException | InvalidSyntaxException e) {
                SystemLogger.error("Unable to remove configuration " + cfg.getPid() + " : " + e.getMessage(), e);
            }
        }
        cfg.setState(ConfigState.UNINSTALLED);
        configList.setChangeCount(-1L);
        configList.setLastInstalled(null);
        return true;
    }
}

