/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.Configuration;
import jakarta.validation.Constraint;
import jakarta.validation.Valid;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableType;
import jakarta.validation.executable.ValidateOnExecution;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.bval.cdi.BValAnnotatedType;
import org.apache.bval.cdi.BValBinding;
import org.apache.bval.cdi.BValInterceptor;
import org.apache.bval.cdi.ValidatorBean;
import org.apache.bval.cdi.ValidatorFactoryBean;
import org.apache.bval.jsr.ConfigurationImpl;
import org.apache.bval.jsr.util.ExecutableTypes;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.Validate;

public class BValExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(BValExtension.class.getName());
    private static final AnnotatedTypeFilter DEFAULT_ANNOTATED_TYPE_FILTER;
    private static AnnotatedTypeFilter annotatedTypeFilter;
    private boolean validatorFound = Boolean.getBoolean("bval.in-container");
    private boolean validatorFactoryFound = Boolean.getBoolean("bval.in-container");
    private final Configuration<?> config;
    private Lazy<ValidatorFactory> factory;
    private Set<ExecutableType> globalExecutableTypes;
    private boolean isExecutableValidationEnabled;
    private final Collection<Class<?>> potentiallyBValAnnotation = new HashSet();
    private final Collection<Class<?>> notBValAnnotation = new HashSet();

    public static void setAnnotatedTypeFilter(AnnotatedTypeFilter annotatedTypeFilter) {
        BValExtension.annotatedTypeFilter = Validate.notNull(annotatedTypeFilter);
    }

    public BValExtension() {
        this.config = Validation.byDefaultProvider().configure();
        try {
            BootstrapConfiguration bootstrap = this.config.getBootstrapConfiguration();
            this.globalExecutableTypes = ExecutableTypes.interpret(bootstrap.getDefaultValidatedExecutableTypes());
            this.isExecutableValidationEnabled = bootstrap.isExecutableValidationEnabled();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            this.globalExecutableTypes = Collections.emptySet();
            this.isExecutableValidationEnabled = false;
        }
    }

    public Set<ExecutableType> getGlobalExecutableTypes() {
        return this.globalExecutableTypes;
    }

    public void addBvalBinding(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addInterceptorBinding(BValBinding.class, new Annotation[0]);
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(BValInterceptor.class), BValExtension.class.getName() + "#" + BValInterceptor.class.getSimpleName());
    }

    public <A> void processAnnotatedType(@Observes ProcessAnnotatedType<A> pat) {
        if (!this.isExecutableValidationEnabled) {
            return;
        }
        AnnotatedType annotatedType = pat.getAnnotatedType();
        if (!annotatedTypeFilter.accept(annotatedType)) {
            return;
        }
        Class javaClass = annotatedType.getJavaClass();
        int modifiers = javaClass.getModifiers();
        if (!(javaClass.isInterface() || javaClass.isAnonymousClass() || Modifier.isFinal(modifiers) || Modifier.isAbstract(modifiers))) {
            try {
                if (this.hasValidation((Annotated)annotatedType) || this.hasValidationAnnotation(annotatedType.getMethods()) || this.hasValidationAnnotation(annotatedType.getConstructors()) || Stream.concat(annotatedType.getMethods().stream(), annotatedType.getConstructors().stream()).flatMap(it -> it.getParameters().stream()).anyMatch(this::hasValidation)) {
                    pat.setAnnotatedType(new BValAnnotatedType(annotatedType));
                }
            }
            catch (Exception e) {
                if (e instanceof ValidationException) {
                    throw e;
                }
                LOGGER.log(Level.INFO, e.getMessage());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    public <A> void processBean(@Observes ProcessBean<A> processBeanEvent) {
        if (this.validatorFound && this.validatorFactoryFound) {
            return;
        }
        Bean bean = processBeanEvent.getBean();
        if (ValidatorBean.class.isInstance(bean) || ValidatorFactoryBean.class.isInstance(bean)) {
            return;
        }
        Set types = bean.getTypes();
        if (!this.validatorFound) {
            this.validatorFound = types.contains(Validator.class);
        }
        if (!this.validatorFactoryFound) {
            this.validatorFactoryFound = types.contains(ValidatorFactory.class);
        }
    }

    public void addBValBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (this.factory != null && this.factory.optional().isPresent()) {
            this.factory.get().close();
        }
        if (this.config instanceof ConfigurationImpl) {
            ((ConfigurationImpl)this.config).releaseDeferredBootstrapOverrides();
        }
        if (!this.validatorFactoryFound) {
            try {
                this.factory = new Lazy<ValidatorFactory>(this.config::buildValidatorFactory);
                afterBeanDiscovery.addBean((Bean)new ValidatorFactoryBean(this.factory));
                this.validatorFactoryFound = true;
            }
            catch (ValidationException validationException) {
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (!this.validatorFound && this.validatorFactoryFound) {
            try {
                afterBeanDiscovery.addBean((Bean)new ValidatorBean(() -> ((ValidatorFactory)CDI.current().select(ValidatorFactory.class, new Annotation[0]).get()).getValidator()));
                this.validatorFound = true;
            }
            catch (ValidationException ve) {
                throw ve;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void afterStart(@Observes AfterDeploymentValidation clearEvent) {
        this.potentiallyBValAnnotation.clear();
        this.notBValAnnotation.clear();
    }

    private boolean hasValidationAnnotation(Collection<? extends Annotated> annotateds) {
        return annotateds.stream().anyMatch(this::hasValidation);
    }

    private boolean hasValidation(Annotated m) {
        return m.getAnnotations().stream().anyMatch(it -> {
            Class<? extends Annotation> type = it.annotationType();
            if (type == ValidateOnExecution.class || type == Valid.class) {
                return true;
            }
            if (this.isSkippedAnnotation(type)) {
                return false;
            }
            if (type.getName().startsWith("jakarta.validation.constraints")) {
                return true;
            }
            if (this.notBValAnnotation.contains(type)) {
                return false;
            }
            if (this.potentiallyBValAnnotation.contains(type)) {
                return true;
            }
            this.cacheIsBvalAnnotation(type);
            return this.potentiallyBValAnnotation.contains(type);
        });
    }

    private boolean isSkippedAnnotation(Class<? extends Annotation> type) {
        if (type.getName().startsWith("java.")) {
            return true;
        }
        if (type.getName().startsWith("jakarta.enterprise.")) {
            return true;
        }
        return type.getName().startsWith("jakarta.inject.");
    }

    private void cacheIsBvalAnnotation(Class<? extends Annotation> type) {
        if (this.flattenAnnotations(type, new HashSet()).anyMatch(it -> it == Constraint.class)) {
            this.potentiallyBValAnnotation.add(type);
        } else {
            this.notBValAnnotation.add(type);
        }
    }

    private Stream<Class<?>> flattenAnnotations(Class<? extends Annotation> type, Set<Class<?>> seen) {
        seen.add(type);
        return Stream.of(type).flatMap(it -> Stream.concat(Stream.of(it), Stream.of(it.getAnnotations()).map(Annotation::annotationType).distinct().filter(a -> !this.isSkippedAnnotation((Class<? extends Annotation>)a)).filter(seen::add).flatMap(a -> this.flattenAnnotations((Class<? extends Annotation>)a, seen))));
    }

    public static <T> Releasable<T> inject(Class<T> clazz) {
        try {
            BeanManager beanManager = CDI.current().getBeanManager();
            if (beanManager == null) {
                return null;
            }
            AnnotatedType annotatedType = beanManager.createAnnotatedType(clazz);
            InjectionTarget it = beanManager.getInjectionTargetFactory(annotatedType).createInjectionTarget(null);
            CreationalContext context = beanManager.createCreationalContext(null);
            Object instance = it.produce(context);
            it.inject(instance, context);
            it.postConstruct(instance);
            return new Releasable<Object>(context, it, instance);
        }
        catch (Exception | NoClassDefFoundError throwable) {
            return null;
        }
    }

    public static BeanManager getBeanManager() {
        return CDI.current().getBeanManager();
    }

    static {
        annotatedTypeFilter = DEFAULT_ANNOTATED_TYPE_FILTER = annotatedType -> !annotatedType.getJavaClass().getName().startsWith("org.apache.bval.");
    }

    public static interface AnnotatedTypeFilter {
        public boolean accept(AnnotatedType<?> var1);
    }

    public static class Releasable<T> {
        private final CreationalContext<T> context;
        private final InjectionTarget<T> injectionTarget;
        private final T instance;

        private Releasable(CreationalContext<T> context, InjectionTarget<T> injectionTarget, T instance) {
            this.context = context;
            this.injectionTarget = injectionTarget;
            this.instance = instance;
        }

        public void release() {
            try {
                this.injectionTarget.preDestroy(this.instance);
                this.injectionTarget.dispose(this.instance);
                this.context.release();
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }

        public T getInstance() {
            return this.instance;
        }
    }
}

