/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.jpetstore.presentation;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.jpetstore.domain.Account;
import com.ibatis.jpetstore.service.AccountService;
import com.ibatis.jpetstore.service.CatalogService;
import com.ibatis.struts.ActionContext;
import com.ibatis.struts.BaseBean;
import com.ibatis.struts.BeanActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccountBean
extends BaseBean {
    private static final AccountService accountService = AccountService.getInstance();
    private static final CatalogService catalogService = CatalogService.getInstance();
    private static final String VALIDATE_NEW_ACCOUNT = "new";
    private static final String VALIDATE_EDIT_ACCOUNT = "edit";
    private static final List LANGUAGE_LIST;
    private static final List CATEGORY_LIST;
    private Account account = new Account();
    private String repeatedPassword;
    private String pageDirection;
    private String validation;
    private PaginatedList myList;
    private boolean authenticated;
    private boolean accountBannerOption;
    private boolean accountListOption;

    public String getUsername() {
        return this.account.getUsername();
    }

    public void setUsername(String username) {
        this.account.setUsername(username);
    }

    public String getPassword() {
        return this.account.getPassword();
    }

    public void setPassword(String password) {
        this.account.setPassword(password);
    }

    public PaginatedList getMyList() {
        return this.myList;
    }

    public void setMyList(PaginatedList myList) {
        this.myList = myList;
    }

    public String getRepeatedPassword() {
        return this.repeatedPassword;
    }

    public void setRepeatedPassword(String repeatedPassword) {
        this.repeatedPassword = repeatedPassword;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
        if (account != null) {
            this.setAccountBannerOption(account.isBannerOption());
            this.setAccountListOption(account.isListOption());
        }
    }

    public List getLanguages() {
        return LANGUAGE_LIST;
    }

    public List getCategories() {
        return CATEGORY_LIST;
    }

    public String getPageDirection() {
        return this.pageDirection;
    }

    public void setPageDirection(String pageDirection) {
        this.pageDirection = pageDirection;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public boolean isAccountBannerOption() {
        return this.accountBannerOption;
    }

    public void setAccountBannerOption(boolean bannerOption) {
        this.accountBannerOption = bannerOption;
    }

    public boolean isAccountListOption() {
        return this.accountListOption;
    }

    public void setAccountListOption(boolean listOption) {
        this.accountListOption = listOption;
    }

    public String newAccount() {
        try {
            this.account.setBannerOption(this.isAccountBannerOption());
            this.account.setListOption(this.isAccountListOption());
            accountService.insertAccount(this.account);
            this.setAccount(accountService.getAccount(this.account.getUsername()));
            this.myList = catalogService.getProductListByCategory(this.account.getFavouriteCategoryId());
            this.authenticated = true;
            this.repeatedPassword = null;
            return "success";
        }
        catch (Exception e) {
            throw new BeanActionException("There was a problem creating your Account Information.  Cause: " + e, (Throwable)e);
        }
    }

    public String editAccountForm() {
        try {
            this.setAccount(accountService.getAccount(this.account.getUsername()));
            return "success";
        }
        catch (Exception e) {
            throw new BeanActionException("There was a problem retrieving your Account Information. Cause: " + e, (Throwable)e);
        }
    }

    public String editAccount() {
        try {
            this.account.setBannerOption(this.isAccountBannerOption());
            this.account.setListOption(this.isAccountListOption());
            accountService.updateAccount(this.account);
            this.setAccount(accountService.getAccount(this.account.getUsername()));
            this.myList = catalogService.getProductListByCategory(this.account.getFavouriteCategoryId());
            return "success";
        }
        catch (Exception e) {
            throw new BeanActionException("There was a problem updating your Account Information. Cause: " + e, (Throwable)e);
        }
    }

    public String switchMyListPage() {
        if ("next".equals(this.pageDirection)) {
            this.myList.nextPage();
        } else if ("previous".equals(this.pageDirection)) {
            this.myList.previousPage();
        }
        return "success";
    }

    public String signon() {
        this.setAccount(accountService.getAccount(this.account.getUsername(), this.account.getPassword()));
        if (this.account == null || this.account == null) {
            ActionContext.getActionContext().setSimpleMessage("Invalid username or password.  Signon failed.");
            this.clear();
            return "failure";
        }
        this.account.setPassword(null);
        this.myList = catalogService.getProductListByCategory(this.account.getFavouriteCategoryId());
        this.authenticated = true;
        return "success";
    }

    public String signoff() {
        ActionContext.getActionContext().getRequest().getSession().invalidate();
        this.clear();
        return "success";
    }

    public boolean isAuthenticated() {
        return this.authenticated && this.account != null && this.account.getUsername() != null;
    }

    public void reset() {
        if (this.account != null) {
            this.setAccountBannerOption(false);
            this.setAccountListOption(false);
        }
    }

    public void clear() {
        this.setAccount(new Account());
        this.repeatedPassword = null;
        this.pageDirection = null;
        this.myList = null;
        this.authenticated = false;
    }

    public void validate() {
        ActionContext ctx = ActionContext.getActionContext();
        if (this.validation != null && (VALIDATE_EDIT_ACCOUNT.equals(this.validation) || VALIDATE_NEW_ACCOUNT.equals(this.validation))) {
            if (VALIDATE_NEW_ACCOUNT.equals(this.validation)) {
                this.account.setStatus("OK");
                this.validateRequiredField(this.account.getUsername(), "User ID is required.");
                if (this.account.getPassword() == null || this.account.getPassword().length() < 1 || !this.account.getPassword().equals(this.repeatedPassword)) {
                    ctx.addSimpleError("Passwords did not match or were not provided.  Matching passwords are required.");
                }
            }
            if (this.account.getPassword() != null && this.account.getPassword().length() > 0 && !this.account.getPassword().equals(this.repeatedPassword)) {
                ctx.addSimpleError("Passwords did not match.");
            }
            this.validateRequiredField(this.account.getFirstName(), "First name is required.");
            this.validateRequiredField(this.account.getLastName(), "Last name is required.");
            this.validateRequiredField(this.account.getEmail(), "Email address is required.");
            this.validateRequiredField(this.account.getPhone(), "Phone number is required.");
            this.validateRequiredField(this.account.getAddress1(), "Address (1) is required.");
            this.validateRequiredField(this.account.getCity(), "City is required.");
            this.validateRequiredField(this.account.getState(), "State is required.");
            this.validateRequiredField(this.account.getZip(), "ZIP is required.");
            this.validateRequiredField(this.account.getCountry(), "Country is required.");
        }
    }

    static {
        ArrayList<String> langList = new ArrayList<String>();
        langList.add("english");
        langList.add("japanese");
        LANGUAGE_LIST = Collections.unmodifiableList(langList);
        ArrayList<String> catList = new ArrayList<String>();
        catList.add("FISH");
        catList.add("DOGS");
        catList.add("REPTILES");
        catList.add("CATS");
        catList.add("BIRDS");
        CATEGORY_LIST = Collections.unmodifiableList(catList);
    }
}

