/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.jpetstore.presentation;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.jpetstore.domain.Category;
import com.ibatis.jpetstore.domain.Item;
import com.ibatis.jpetstore.domain.Product;
import com.ibatis.jpetstore.service.CatalogService;
import com.ibatis.struts.ActionContext;
import com.ibatis.struts.BaseBean;

public class CatalogBean
extends BaseBean {
    private static final CatalogService catalogService = CatalogService.getInstance();
    private String keyword;
    private String pageDirection;
    private String categoryId;
    private Category category;
    private PaginatedList categoryList;
    private String productId;
    private Product product;
    private PaginatedList productList;
    private String itemId;
    private Item item;
    private PaginatedList itemList;

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getPageDirection() {
        return this.pageDirection;
    }

    public void setPageDirection(String pageDirection) {
        this.pageDirection = pageDirection;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public PaginatedList getCategoryList() {
        return this.categoryList;
    }

    public void setCategoryList(PaginatedList categoryList) {
        this.categoryList = categoryList;
    }

    public PaginatedList getProductList() {
        return this.productList;
    }

    public void setProductList(PaginatedList productList) {
        this.productList = productList;
    }

    public PaginatedList getItemList() {
        return this.itemList;
    }

    public void setItemList(PaginatedList itemList) {
        this.itemList = itemList;
    }

    public String viewCategory() {
        if (this.categoryId != null) {
            this.productList = catalogService.getProductListByCategory(this.categoryId);
            this.category = catalogService.getCategory(this.categoryId);
        }
        return "success";
    }

    public String searchProducts() {
        if (this.keyword == null || this.keyword.length() < 1) {
            ActionContext.getActionContext().setSimpleMessage("Please enter a keyword to search for, then press the search button.");
            return "failure";
        }
        this.productList = catalogService.searchProductList(this.keyword.toLowerCase());
        return "success";
    }

    public String switchProductListPage() {
        if ("next".equals(this.pageDirection)) {
            this.productList.nextPage();
        } else if ("previous".equals(this.pageDirection)) {
            this.productList.previousPage();
        }
        return "success";
    }

    public String viewProduct() {
        if (this.productId != null) {
            this.itemList = catalogService.getItemListByProduct(this.productId);
            this.product = catalogService.getProduct(this.productId);
        }
        return "success";
    }

    public String switchItemListPage() {
        if ("next".equals(this.pageDirection)) {
            this.itemList.nextPage();
        } else if ("previous".equals(this.pageDirection)) {
            this.itemList.previousPage();
        }
        return "success";
    }

    public String viewItem() {
        this.item = catalogService.getItem(this.itemId);
        this.product = this.item.getProduct();
        return "success";
    }

    public void clear() {
        this.keyword = null;
        this.pageDirection = null;
        this.categoryId = null;
        this.category = null;
        this.categoryList = null;
        this.productId = null;
        this.product = null;
        this.productList = null;
        this.itemId = null;
        this.item = null;
        this.itemList = null;
    }
}

