/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.commons;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import junitx.util.PrivateAccessor;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.InstanceFilter;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.base.commons.DefaultTopologyView;
import org.apache.sling.discovery.base.its.setup.TopologyHelper;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTopologyViewTest {
    @Test
    public void testForcedLeaderChangeCompare() throws Exception {
        String slingId1 = UUID.randomUUID().toString();
        DefaultTopologyView view1 = TopologyHelper.createTopologyView(UUID.randomUUID().toString(), slingId1);
        DefaultInstanceDescription id2 = TopologyHelper.addInstanceDescription(view1, TopologyHelper.createInstanceDescription((ClusterView)view1.getClusterViews().iterator().next()));
        String slingId2 = id2.getSlingId();
        DefaultInstanceDescription id3 = TopologyHelper.addInstanceDescription(view1, TopologyHelper.createInstanceDescription((ClusterView)view1.getClusterViews().iterator().next()));
        String slingId3 = id3.getSlingId();
        DefaultTopologyView view2 = TopologyHelper.cloneTopologyView(view1, slingId2);
        Assert.assertNotEquals((Object)((ClusterView)view1.getClusterViews().iterator().next()).getLeader().getSlingId(), (Object)((ClusterView)view2.getClusterViews().iterator().next()).getLeader().getSlingId());
        Assert.assertTrue((view1.compareTopology(view2) == TopologyEvent.Type.TOPOLOGY_CHANGED ? 1 : 0) != 0);
        DefaultTopologyView view3 = TopologyHelper.cloneTopologyView(view1, slingId3);
        Assert.assertNotEquals((Object)((ClusterView)view1.getClusterViews().iterator().next()).getLeader().getSlingId(), (Object)((ClusterView)view3.getClusterViews().iterator().next()).getLeader().getSlingId());
        Assert.assertTrue((view1.compareTopology(view3) == TopologyEvent.Type.TOPOLOGY_CHANGED ? 1 : 0) != 0);
    }

    @Test
    public void testComparelocalClusterSyncTokenId() throws Exception {
        String clusterViewId = UUID.randomUUID().toString();
        String slingId = UUID.randomUUID().toString();
        String syncTokenId = UUID.randomUUID().toString();
        DefaultTopologyView t1 = this.createSingleInstanceTopology(slingId, clusterViewId, syncTokenId);
        DefaultTopologyView t2 = this.createSingleInstanceTopology(slingId, clusterViewId, syncTokenId);
        Assert.assertNull((Object)t1.compareTopology(t2));
        Assert.assertNull((Object)t2.compareTopology(t1));
        DefaultTopologyView t3 = this.createSingleInstanceTopology(slingId, clusterViewId, UUID.randomUUID().toString());
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)t1.compareTopology(t3));
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)t3.compareTopology(t1));
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)t2.compareTopology(t3));
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)t3.compareTopology(t2));
        DefaultTopologyView t4 = this.createSingleInstanceTopology(slingId, clusterViewId, null);
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)t1.compareTopology(t4));
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)t4.compareTopology(t1));
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)t2.compareTopology(t4));
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)t4.compareTopology(t2));
        DefaultTopologyView t5 = this.createSingleInstanceTopology(slingId, clusterViewId, null);
        Assert.assertNull((Object)t5.compareTopology(t4));
        Assert.assertNull((Object)t4.compareTopology(t5));
    }

    private DefaultTopologyView createSingleInstanceTopology(String slingId, String clusterViewId, String syncTokenId) {
        LocalClusterView clusterView = new LocalClusterView(clusterViewId, syncTokenId);
        DefaultInstanceDescription instance = TopologyHelper.createInstanceDescription(slingId, true, (ClusterView)clusterView);
        DefaultTopologyView t = new DefaultTopologyView();
        t.setLocalClusterView(clusterView);
        return t;
    }

    @Test
    public void testCompare() throws Exception {
        DefaultTopologyView newView = TopologyHelper.createTopologyView(UUID.randomUUID().toString(), UUID.randomUUID().toString());
        try {
            newView.compareTopology(null);
            Assert.fail((String)"Should complain about null");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultTopologyView oldView = TopologyHelper.cloneTopologyView(newView);
        Assert.assertNull((Object)newView.compareTopology(oldView));
        DefaultInstanceDescription id = TopologyHelper.createInstanceDescription((ClusterView)newView.getClusterViews().iterator().next());
        TopologyHelper.addInstanceDescription(newView, id);
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)newView.compareTopology(oldView));
        Assert.assertEquals((long)2L, (long)newView.getInstances().size());
        TopologyHelper.addInstanceDescription(newView, id);
        Assert.assertEquals((long)2L, (long)newView.getInstances().size());
        oldView = TopologyHelper.cloneTopologyView(newView);
        Assert.assertNull((Object)newView.compareTopology(oldView));
        DefaultInstanceDescription instance = (DefaultInstanceDescription)newView.getInstances().iterator().next();
        instance.setProperty("a", "b");
        Assert.assertEquals((Object)TopologyEvent.Type.PROPERTIES_CHANGED, (Object)newView.compareTopology(oldView));
        oldView = TopologyHelper.cloneTopologyView(newView);
        Assert.assertNull((Object)newView.compareTopology(oldView));
        instance.setProperty("a", "B");
        Assert.assertEquals((Object)TopologyEvent.Type.PROPERTIES_CHANGED, (Object)newView.compareTopology(oldView));
        oldView = TopologyHelper.cloneTopologyView(newView);
        Assert.assertNull((Object)newView.compareTopology(oldView));
        instance.setProperty("a", "B");
        Assert.assertNull((Object)newView.compareTopology(oldView));
        Iterator it = newView.getInstances().iterator();
        DefaultInstanceDescription firstInstance = (DefaultInstanceDescription)it.next();
        Assert.assertNotNull((Object)firstInstance);
        DefaultInstanceDescription secondInstance = (DefaultInstanceDescription)it.next();
        Assert.assertNotNull((Object)secondInstance);
        firstInstance.setProperty("c", "d");
        DefaultClusterView cluster = new DefaultClusterView(UUID.randomUUID().toString());
        PrivateAccessor.setField((Object)secondInstance, (String)"clusterView", null);
        cluster.addInstanceDescription(secondInstance);
        Assert.assertEquals((Object)TopologyEvent.Type.TOPOLOGY_CHANGED, (Object)newView.compareTopology(oldView));
    }

    @Test
    public void testFind() throws Exception {
        DefaultTopologyView newView = TopologyHelper.createTopologyView(UUID.randomUUID().toString(), UUID.randomUUID().toString());
        TopologyHelper.createAndAddInstanceDescription(newView, (ClusterView)newView.getClusterViews().iterator().next());
        try {
            newView.findInstances(null);
            Assert.fail((String)"should complain");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        final DefaultInstanceDescription id = TopologyHelper.createAndAddInstanceDescription(newView, (ClusterView)newView.getClusterViews().iterator().next());
        TopologyHelper.createAndAddInstanceDescription(newView, (ClusterView)newView.getClusterViews().iterator().next());
        Assert.assertEquals((long)4L, (long)newView.findInstances(new InstanceFilter(){

            public boolean accept(InstanceDescription instance) {
                return true;
            }
        }).size());
        Assert.assertEquals((long)1L, (long)newView.findInstances(new InstanceFilter(){

            public boolean accept(InstanceDescription instance) {
                return instance.getSlingId().equals(id.getSlingId());
            }
        }).size());
        Assert.assertEquals((long)1L, (long)newView.findInstances(new InstanceFilter(){

            public boolean accept(InstanceDescription instance) {
                return instance.isLeader();
            }
        }).size());
        Assert.assertEquals((long)1L, (long)newView.findInstances(new InstanceFilter(){
            boolean first = true;

            public boolean accept(InstanceDescription instance) {
                if (!this.first) {
                    return false;
                }
                this.first = false;
                return true;
            }
        }).size());
    }

    @Test
    public void testGetInstances() throws Exception {
        DefaultTopologyView newView = TopologyHelper.createTopologyView(UUID.randomUUID().toString(), UUID.randomUUID().toString());
        Set instances = newView.getInstances();
        Assert.assertNotNull((Object)instances);
        try {
            instances.remove(instances.iterator().next());
            Assert.fail((String)"list should not be modifiable");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

