/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.jackrabbit.usermanager.impl.resource.AuthorizableResourceProvider;
import org.apache.sling.jackrabbit.usermanager.impl.resource.BaseAuthorizableValueMap;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.jetbrains.annotations.NotNull;

public class NestedAuthorizableValueMap
extends BaseAuthorizableValueMap {
    private final String relPropPath;

    public NestedAuthorizableValueMap(Authorizable authorizable, SystemUserManagerPaths systemUserManagerPaths, @NotNull String relPropPath) {
        super(authorizable, systemUserManagerPaths);
        this.relPropPath = relPropPath;
    }

    @Override
    protected Object read(String key) {
        Object value = null;
        if (!this.fullyRead) {
            try {
                String relPropKey = String.format("%s/%s", this.relPropPath, key);
                if (this.authorizable.hasProperty(relPropKey)) {
                    value = this.readPropertyAndCache(key, relPropKey);
                }
            }
            catch (RepositoryException re) {
                this.log.error("Could not access authorizable property", (Throwable)re);
            }
        }
        return value;
    }

    @Override
    protected void readFully() {
        if (!this.fullyRead) {
            try {
                Iterator<String> pi = AuthorizableResourceProvider.getPropertyNames(this.relPropPath, this.authorizable);
                while (pi.hasNext()) {
                    String key = pi.next();
                    if (this.cache.containsKey(key)) continue;
                    this.readPropertyAndCache(key, String.format("%s/%s", this.relPropPath, key));
                }
                this.fullyRead = true;
            }
            catch (RepositoryException re) {
                this.log.error("Could not access certain properties of user {}", (Object)this.authorizable, (Object)re);
            }
        }
    }

    @Override
    protected <T> T convertToType(String name, Class<T> type) {
        return super.convertToType(String.format("%s/%s", this.relPropPath, name), type);
    }
}

