/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.testmodels.classes.DefaultStringModel;
import org.apache.sling.models.testmodels.classes.constructorinjection.DefaultPrimitivesModel;
import org.apache.sling.models.testmodels.classes.constructorinjection.DefaultWrappersModel;
import org.apache.sling.models.testmodels.interfaces.PropertyModelWithDefaults;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DefaultTest {
    private ModelAdapterFactory factory;

    DefaultTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new ValueMapInjector());
        this.factory.implementationPickers = Collections.emptyList();
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{DefaultStringModel.class, PropertyModelWithDefaults.class, org.apache.sling.models.testmodels.classes.DefaultPrimitivesModel.class, org.apache.sling.models.testmodels.classes.DefaultWrappersModel.class, DefaultPrimitivesModel.class, org.apache.sling.models.testmodels.classes.constructorinjection.DefaultStringModel.class, DefaultWrappersModel.class});
    }

    @Test
    void testDefaultStringValueField() {
        ValueMapDecorator vm = new ValueMapDecorator(Collections.emptyMap());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        DefaultStringModel model = (DefaultStringModel)this.factory.getAdapter((Object)res, DefaultStringModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"firstDefault", (Object)model.getFirstProperty());
        Assertions.assertEquals((int)2, (int)model.getSecondProperty().length);
    }

    @Test
    void testDefaultStringValueOnInterfaceField() {
        ValueMapDecorator vm = new ValueMapDecorator(Collections.singletonMap("first", "first value"));
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        PropertyModelWithDefaults model = (PropertyModelWithDefaults)this.factory.getAdapter((Object)res, PropertyModelWithDefaults.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"first value", (Object)model.getFirst());
        Assertions.assertEquals((Object)"second default", (Object)model.getSecond());
    }

    @Test
    void testDefaultPrimitivesField() {
        ValueMapDecorator vm = new ValueMapDecorator(Collections.emptyMap());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        org.apache.sling.models.testmodels.classes.DefaultPrimitivesModel model = (org.apache.sling.models.testmodels.classes.DefaultPrimitivesModel)this.factory.getAdapter((Object)res, org.apache.sling.models.testmodels.classes.DefaultPrimitivesModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)true, (Object)model.getBooleanProperty());
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true}, (boolean[])model.getBooleanArrayProperty());
        Assertions.assertEquals((long)1L, (long)model.getLongProperty());
        Assertions.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])model.getLongArrayProperty());
    }

    @Test
    void testDefaultWrappersField() {
        ValueMapDecorator vm = new ValueMapDecorator(Collections.emptyMap());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        org.apache.sling.models.testmodels.classes.DefaultWrappersModel model = (org.apache.sling.models.testmodels.classes.DefaultWrappersModel)this.factory.getAdapter((Object)res, org.apache.sling.models.testmodels.classes.DefaultWrappersModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)true, (Object)model.getBooleanWrapperProperty());
        Assertions.assertArrayEquals((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}, (Object[])model.getBooleanWrapperArrayProperty());
        Assertions.assertEquals((Long)1L, (Long)model.getLongWrapperProperty());
        Assertions.assertArrayEquals((Object[])new Long[]{1L, 1L}, (Object[])model.getLongWrapperArrayProperty());
    }

    @Test
    void testDefaultStringValueConstructor() {
        ValueMapDecorator vm = new ValueMapDecorator(Collections.emptyMap());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        org.apache.sling.models.testmodels.classes.constructorinjection.DefaultStringModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.DefaultStringModel)this.factory.getAdapter((Object)res, org.apache.sling.models.testmodels.classes.constructorinjection.DefaultStringModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"firstDefault", (Object)model.getFirstProperty());
        Assertions.assertEquals((int)2, (int)model.getSecondProperty().length);
    }

    @Test
    void testDefaultPrimitivesConstructor() {
        ValueMapDecorator vm = new ValueMapDecorator(Collections.emptyMap());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        DefaultPrimitivesModel model = (DefaultPrimitivesModel)this.factory.getAdapter((Object)res, DefaultPrimitivesModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)true, (Object)model.getBooleanProperty());
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true}, (boolean[])model.getBooleanArrayProperty());
        Assertions.assertEquals((long)1L, (long)model.getLongProperty());
        Assertions.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])model.getLongArrayProperty());
    }

    @Test
    void testDefaultWrappersConstructor() {
        ValueMapDecorator vm = new ValueMapDecorator(Collections.emptyMap());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        DefaultWrappersModel model = (DefaultWrappersModel)this.factory.getAdapter((Object)res, DefaultWrappersModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)true, (Object)model.getBooleanWrapperProperty());
        Assertions.assertArrayEquals((Object[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}, (Object[])model.getBooleanWrapperArrayProperty());
        Assertions.assertEquals((Long)1L, (Long)model.getLongWrapperProperty());
        Assertions.assertArrayEquals((Object[])new Long[]{1L, 1L}, (Object[])model.getLongWrapperArrayProperty());
    }
}

