/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.models.annotations.injectorspecific.ResourcePath;
import org.apache.sling.models.impl.injectors.ResourcePathInjector;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ResourcePathInjectorTest {
    private ResourcePathInjector injector = new ResourcePathInjector();
    @Mock
    private AnnotatedElement element;
    @Mock
    private DisposalCallbackRegistry registry;
    @Mock
    private Resource resource;
    @Mock
    private SlingJakartaHttpServletRequest jakartaRequest;

    ResourcePathInjectorTest() {
    }

    @BeforeEach
    void setUp() {
        ResourcePath mockResourcePath = (ResourcePath)Mockito.mock(ResourcePath.class);
        Mockito.lenient().when((Object)mockResourcePath.path()).thenReturn((Object)"/resource1");
        Mockito.lenient().when((Object)this.element.getAnnotation(ResourcePath.class)).thenReturn((Object)mockResourcePath);
        ResourceResolver mockRR = (ResourceResolver)Mockito.mock(ResourceResolver.class);
        Mockito.lenient().when((Object)mockRR.getResource("/resource1")).thenReturn((Object)this.resource);
        Mockito.lenient().when((Object)this.jakartaRequest.getResourceResolver()).thenReturn((Object)mockRR);
    }

    @Test
    void testResourcePathFromJakartaRequest() {
        Object result = this.injector.getValue((Object)this.jakartaRequest, null, Resource.class, this.element, this.registry);
        Assertions.assertEquals((Object)result, (Object)this.resource);
    }

    @Deprecated(since="2.0.0")
    @Test
    void testResourcePathFromJavaxRequest() {
        SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.jakartaRequest);
        Object result = this.injector.getValue((Object)javaxRequest, null, Resource.class, this.element, this.registry);
        Assertions.assertEquals((Object)result, (Object)this.resource);
    }
}

