/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.jcr.delegate.AuthorizableDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.ImpersonationDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UserDelegator
extends AuthorizableDelegator
implements User {
    private UserDelegator(SessionDelegate sessionDelegate, User userDelegate) {
        super(sessionDelegate, userDelegate);
    }

    @NotNull
    static User wrap(@NotNull SessionDelegate sessionDelegate, @NotNull User user) {
        return new UserDelegator(sessionDelegate, user);
    }

    @NotNull
    static User unwrap(@NotNull User user) {
        if (user instanceof UserDelegator) {
            return ((UserDelegator)user).getDelegate();
        }
        return user;
    }

    @NotNull
    private User getDelegate() {
        return (User)this.delegate;
    }

    @Override
    public boolean isAdmin() {
        return this.sessionDelegate.safePerform(new SessionOperation<Boolean>("isAdmin"){

            @Override
            @NotNull
            public Boolean perform() {
                return UserDelegator.this.getDelegate().isAdmin();
            }
        });
    }

    @Override
    public boolean isSystemUser() {
        return this.sessionDelegate.safePerform(new SessionOperation<Boolean>("isSystemUser"){

            @Override
            @NotNull
            public Boolean perform() {
                return UserDelegator.this.getDelegate().isSystemUser();
            }
        });
    }

    @Override
    @NotNull
    public Credentials getCredentials() {
        return this.sessionDelegate.safePerform(new SessionOperation<Credentials>("getCredentials"){

            @Override
            @NotNull
            public Credentials perform() throws RepositoryException {
                return UserDelegator.this.getDelegate().getCredentials();
            }
        });
    }

    @Override
    @NotNull
    public Impersonation getImpersonation() {
        return this.sessionDelegate.safePerform(new SessionOperation<Impersonation>("getImpersonation"){

            @Override
            @NotNull
            public Impersonation perform() throws RepositoryException {
                Impersonation impersonation = UserDelegator.this.getDelegate().getImpersonation();
                return ImpersonationDelegator.wrap(UserDelegator.this.sessionDelegate, impersonation);
            }
        });
    }

    @Override
    public void changePassword(final @Nullable String password) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("changePassword", true){

            @Override
            public void performVoid() throws RepositoryException {
                UserDelegator.this.getDelegate().changePassword(password);
            }
        });
    }

    @Override
    public void changePassword(final @Nullable String password, final @NotNull String oldPassword) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("changePassword", true){

            @Override
            public void performVoid() throws RepositoryException {
                UserDelegator.this.getDelegate().changePassword(password, oldPassword);
            }
        });
    }

    @Override
    public void disable(final @Nullable String reason) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("disable", true){

            @Override
            public void performVoid() throws RepositoryException {
                UserDelegator.this.getDelegate().disable(reason);
            }
        });
    }

    @Override
    public boolean isDisabled() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("isDisabled"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return UserDelegator.this.getDelegate().isDisabled();
            }
        });
    }

    @Override
    @Nullable
    public String getDisabledReason() throws RepositoryException {
        return this.sessionDelegate.performNullable(new SessionOperation<String>("getDisabledReason"){

            @Override
            public String performNullable() throws RepositoryException {
                return UserDelegator.this.getDelegate().getDisabledReason();
            }
        });
    }
}

