/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefReader;
import org.apache.jackrabbit.commons.cnd.DefinitionBuilderFactory;
import org.apache.jackrabbit.commons.cnd.TemplateBuilderFactory;
import org.apache.sling.testing.mock.osgi.ManifestScanner;
import org.apache.sling.testing.mock.sling.NodeTypeMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeTypeDefinitionScanner {
    private static final NodeTypeDefinitionScanner SINGLETON = new NodeTypeDefinitionScanner();
    private static final Logger log = LoggerFactory.getLogger(NodeTypeDefinitionScanner.class);
    private final List<String> nodeTypeDefinitions = NodeTypeDefinitionScanner.findeNodeTypeDefinitions();

    private NodeTypeDefinitionScanner() {
    }

    public List<String> getNodeTypeDefinitions() {
        return this.nodeTypeDefinitions;
    }

    public void register(Session session, NodeTypeMode nodeTypeMode) throws RepositoryException {
        List<String> nodeTypeResources = this.getNodeTypeDefinitions();
        this.register(session, nodeTypeResources, nodeTypeMode);
    }

    public void register(Session session, List<String> nodeTypeResources, NodeTypeMode nodeTypeMode) throws RepositoryException {
        switch (nodeTypeMode) {
            case NOT_SUPPORTED: {
                break;
            }
            case NAMESPACES_ONLY: {
                this.registerNamespaces(session, nodeTypeResources);
                break;
            }
            case NODETYPES_REQUIRED: {
                this.registerNodeTypes(session, nodeTypeResources);
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type mode not supported: " + String.valueOf((Object)nodeTypeMode));
            }
        }
    }

    private void registerNamespaces(Session session, List<String> nodeTypeResources) throws RepositoryException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Workspace workspace = session.getWorkspace();
        NamespaceRegistry namespaceRegistry = workspace.getNamespaceRegistry();
        ValueFactory valueFactory = session.getValueFactory();
        TemplateBuilderFactory factory = new TemplateBuilderFactory((NodeTypeManager)new DummyNodeTypeManager(), valueFactory, namespaceRegistry);
        for (String nodeTypeResource : nodeTypeResources) {
            try {
                InputStream is = classLoader.getResourceAsStream(nodeTypeResource);
                try {
                    if (is == null) continue;
                    InputStreamReader reader = new InputStreamReader(is);
                    CompactNodeTypeDefReader cndReader = new CompactNodeTypeDefReader((Reader)reader, nodeTypeResource, (DefinitionBuilderFactory)factory);
                    NamespaceRegistry mapping = (NamespaceRegistry)cndReader.getNamespaceMapping();
                    for (int i = 0; i < mapping.getURIs().length; ++i) {
                        String uri = mapping.getURIs()[i];
                        String prefix = mapping.getPrefix(uri);
                        try {
                            namespaceRegistry.registerNamespace(prefix, uri);
                            continue;
                        }
                        catch (RepositoryException repositoryException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Throwable ex) {
                log.warn("Unable to parse node type definition: " + nodeTypeResource, ex);
            }
        }
    }

    private void registerNodeTypes(Session session, List<String> nodeTypeResources) throws RepositoryException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Workspace workspace = session.getWorkspace();
        NodeTypeManager nodeTypeManager = workspace.getNodeTypeManager();
        NamespaceRegistry namespaceRegistry = workspace.getNamespaceRegistry();
        ValueFactory valueFactory = session.getValueFactory();
        TemplateBuilderFactory factory = new TemplateBuilderFactory(nodeTypeManager, valueFactory, namespaceRegistry);
        HashMap<String, NodeTypeTemplate> nodeTypes = new HashMap<String, NodeTypeTemplate>();
        for (String resource : nodeTypeResources) {
            nodeTypes.putAll(this.parseNodeTypesFromResource(resource, classLoader, (DefinitionBuilderFactory<NodeTypeTemplate, NamespaceRegistry>)factory));
        }
        nodeTypeManager.registerNodeTypes((NodeTypeDefinition[])nodeTypes.values().toArray(new NodeTypeTemplate[0]), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, NodeTypeTemplate> parseNodeTypesFromResource(String resource, ClassLoader classLoader, DefinitionBuilderFactory<NodeTypeTemplate, NamespaceRegistry> factory) {
        try (InputStream is = classLoader.getResourceAsStream(resource);){
            if (is == null) {
                Map<String, NodeTypeTemplate> map = Map.of();
                return map;
            }
            CompactNodeTypeDefReader cndReader = new CompactNodeTypeDefReader((Reader)new InputStreamReader(is), resource, factory);
            HashMap<String, NodeTypeTemplate> result = new HashMap<String, NodeTypeTemplate>();
            for (NodeTypeTemplate template : cndReader.getNodeTypeDefinitions()) {
                result.put(template.getName(), template);
            }
            HashMap<String, NodeTypeTemplate> hashMap = result;
            return hashMap;
        }
        catch (Throwable ex) {
            log.warn("Failed to parse CND resource: " + resource, ex);
            return Map.of();
        }
    }

    private static List<String> findeNodeTypeDefinitions() {
        return new ArrayList<String>(ManifestScanner.getValues((String)"Sling-Nodetypes"));
    }

    public static NodeTypeDefinitionScanner get() {
        return SINGLETON;
    }

    private static class DummyNodeTypeManager
    implements NodeTypeManager {
        private DummyNodeTypeManager() {
        }

        public NodeType getNodeType(String nodeTypeName) {
            return null;
        }

        public boolean hasNodeType(String name) {
            return false;
        }

        public NodeTypeIterator getAllNodeTypes() {
            return null;
        }

        public NodeTypeIterator getPrimaryNodeTypes() {
            return null;
        }

        public NodeTypeIterator getMixinNodeTypes() {
            return null;
        }

        public NodeTypeTemplate createNodeTypeTemplate() {
            return new DummyNodeTypeTemplate();
        }

        public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) {
            return new DummyNodeTypeTemplate();
        }

        public NodeDefinitionTemplate createNodeDefinitionTemplate() {
            return new DummyNodeDefinitionTemplate();
        }

        public PropertyDefinitionTemplate createPropertyDefinitionTemplate() {
            return new DummyPropertyDefinitionTemplate();
        }

        public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) {
            return null;
        }

        public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) {
            return null;
        }

        public void unregisterNodeType(String name) {
        }

        public void unregisterNodeTypes(String[] names) {
        }
    }

    private static class DummyPropertyDefinitionTemplate
    implements PropertyDefinitionTemplate {
        private DummyPropertyDefinitionTemplate() {
        }

        public int getRequiredType() {
            return 0;
        }

        public String[] getValueConstraints() {
            return null;
        }

        public Value[] getDefaultValues() {
            return null;
        }

        public boolean isMultiple() {
            return false;
        }

        public String[] getAvailableQueryOperators() {
            return null;
        }

        public boolean isFullTextSearchable() {
            return false;
        }

        public boolean isQueryOrderable() {
            return false;
        }

        public NodeType getDeclaringNodeType() {
            return null;
        }

        public String getName() {
            return null;
        }

        public boolean isAutoCreated() {
            return false;
        }

        public boolean isMandatory() {
            return false;
        }

        public int getOnParentVersion() {
            return 0;
        }

        public boolean isProtected() {
            return false;
        }

        public void setName(String name) {
        }

        public void setAutoCreated(boolean autoCreated) {
        }

        public void setMandatory(boolean mandatory) {
        }

        public void setOnParentVersion(int opv) {
        }

        public void setProtected(boolean protectedStatus) {
        }

        public void setRequiredType(int type) {
        }

        public void setValueConstraints(String[] constraints) {
        }

        public void setDefaultValues(Value[] defaultValues) {
        }

        public void setMultiple(boolean multiple) {
        }

        public void setAvailableQueryOperators(String[] operators) {
        }

        public void setFullTextSearchable(boolean fullTextSearchable) {
        }

        public void setQueryOrderable(boolean queryOrderable) {
        }
    }

    private static class DummyNodeDefinitionTemplate
    implements NodeDefinitionTemplate {
        private DummyNodeDefinitionTemplate() {
        }

        public NodeType[] getRequiredPrimaryTypes() {
            return null;
        }

        public String[] getRequiredPrimaryTypeNames() {
            return null;
        }

        public NodeType getDefaultPrimaryType() {
            return null;
        }

        public String getDefaultPrimaryTypeName() {
            return null;
        }

        public boolean allowsSameNameSiblings() {
            return false;
        }

        public NodeType getDeclaringNodeType() {
            return null;
        }

        public String getName() {
            return null;
        }

        public boolean isAutoCreated() {
            return false;
        }

        public boolean isMandatory() {
            return false;
        }

        public int getOnParentVersion() {
            return 0;
        }

        public boolean isProtected() {
            return false;
        }

        public void setName(String name) {
        }

        public void setAutoCreated(boolean autoCreated) {
        }

        public void setMandatory(boolean mandatory) {
        }

        public void setOnParentVersion(int opv) {
        }

        public void setProtected(boolean protectedStatus) {
        }

        public void setRequiredPrimaryTypeNames(String[] names) {
        }

        public void setDefaultPrimaryTypeName(String name) {
        }

        public void setSameNameSiblings(boolean allowSameNameSiblings) {
        }
    }

    private static class DummyNodeTypeTemplate
    implements NodeTypeTemplate {
        private DummyNodeTypeTemplate() {
        }

        public String getName() {
            return null;
        }

        public String[] getDeclaredSupertypeNames() {
            return null;
        }

        public boolean isAbstract() {
            return false;
        }

        public boolean isMixin() {
            return false;
        }

        public boolean hasOrderableChildNodes() {
            return false;
        }

        public boolean isQueryable() {
            return false;
        }

        public String getPrimaryItemName() {
            return null;
        }

        public PropertyDefinition[] getDeclaredPropertyDefinitions() {
            return null;
        }

        public NodeDefinition[] getDeclaredChildNodeDefinitions() {
            return null;
        }

        public void setName(String name) {
        }

        public void setDeclaredSuperTypeNames(String[] names) {
        }

        public void setAbstract(boolean abstractStatus) {
        }

        public void setMixin(boolean mixin) {
        }

        public void setOrderableChildNodes(boolean orderable) {
        }

        public void setPrimaryItemName(String name) {
        }

        public void setQueryable(boolean queryable) {
        }

        public List getPropertyDefinitionTemplates() {
            return new ArrayList();
        }

        public List getNodeDefinitionTemplates() {
            return new ArrayList();
        }
    }
}

