/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.tree;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.explain.tree.IExplainTreeNode;
import org.eclipse.core.runtime.IAdaptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExplainAbstractTreeNode
implements IExplainTreeNode,
IAdaptable {
    private IExplainTreeNode parent;
    private List<IExplainTreeNode> children;
    private FeatureStructure fs;
    private TypeSystem ts;

    public ExplainAbstractTreeNode(IExplainTreeNode parent, FeatureStructure fs, TypeSystem ts) {
        this.parent = parent;
        this.children = new ArrayList<IExplainTreeNode>();
        this.fs = fs;
        this.ts = ts;
    }

    @Override
    public IExplainTreeNode getParent() {
        return this.parent;
    }

    @Override
    public List<IExplainTreeNode> getChildren() {
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public void addChild(IExplainTreeNode child) {
        this.children.add(child);
    }

    @Override
    public boolean removeChild(IExplainTreeNode child) {
        return this.children.remove(child);
    }

    @Override
    public FeatureStructure getFeatureStructure() {
        return this.fs;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    public String toString() {
        return this.fs.toString();
    }

    public Object getAdapter(Class adapter) {
        if (FeatureStructure.class.equals((Object)adapter)) {
            return this.getFeatureStructure();
        }
        if (AnnotationFS.class.equals((Object)adapter) && this.getFeatureStructure() instanceof AnnotationFS) {
            return this.getFeatureStructure();
        }
        return null;
    }
}

