/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.util.Stack;
import org.apache.uima.ruta.resource.MultiTextNode;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class TrieXMLEventHandler
extends DefaultHandler {
    private Stack<MultiTextNode> stack = new Stack();
    boolean inContent;
    boolean inType;

    public TrieXMLEventHandler(MultiTextNode root) {
        this.stack.add(root);
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) {
        if ("n".equals(localName) || "n".equals(qualifiedName)) {
            MultiTextNode newNode = new MultiTextNode();
            this.stack.add(newNode);
            this.inContent = false;
            this.inType = false;
        }
        if ("t".equals(localName) || "t".equals(qualifiedName)) {
            this.inType = true;
            this.inContent = false;
        }
        if ("c".equals(localName) || "c".equals(qualifiedName)) {
            this.inType = false;
            this.inContent = true;
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        if ("n".equals(localName) || "n".equals(qualifiedName)) {
            MultiTextNode pop = this.stack.pop();
            this.stack.peek().addChild(pop);
        }
        if ("t".equals(localName) || "t".equals(qualifiedName)) {
            this.inType = false;
        }
        if ("c".equals(localName) || "c".equals(qualifiedName)) {
            this.inContent = false;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.stack.isEmpty()) {
            return;
        }
        MultiTextNode peek = this.stack.peek();
        if (this.inType) {
            StringBuilder type = new StringBuilder();
            for (int i = start; i < start + length; ++i) {
                type.append(String.valueOf(ch[i]));
            }
            peek.addType(type.toString());
        } else if (this.inContent) {
            if (ch.length > 0) {
                peek.setValue(ch[0]);
            } else {
                peek.setValue(' ');
            }
        }
    }
}

