﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-meetings/ChimeSDKMeetings_EXPORTS.h>
#include <aws/chime-sdk-meetings/model/Meeting.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKMeetings {
namespace Model {
class CreateMeetingResult {
 public:
  AWS_CHIMESDKMEETINGS_API CreateMeetingResult() = default;
  AWS_CHIMESDKMEETINGS_API CreateMeetingResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CHIMESDKMEETINGS_API CreateMeetingResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The meeting information, including the meeting ID and
   * <code>MediaPlacement</code>.</p>
   */
  inline const Meeting& GetMeeting() const { return m_meeting; }
  template <typename MeetingT = Meeting>
  void SetMeeting(MeetingT&& value) {
    m_meetingHasBeenSet = true;
    m_meeting = std::forward<MeetingT>(value);
  }
  template <typename MeetingT = Meeting>
  CreateMeetingResult& WithMeeting(MeetingT&& value) {
    SetMeeting(std::forward<MeetingT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateMeetingResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Meeting m_meeting;

  Aws::String m_requestId;
  bool m_meetingHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKMeetings
}  // namespace Aws
