﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/datazone/DataZone_EXPORTS.h>
#include <aws/datazone/model/CustomParameter.h>
#include <aws/datazone/model/DeploymentProperties.h>
#include <aws/datazone/model/ProvisioningProperties.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DataZone {
namespace Model {
class GetEnvironmentBlueprintResult {
 public:
  AWS_DATAZONE_API GetEnvironmentBlueprintResult() = default;
  AWS_DATAZONE_API GetEnvironmentBlueprintResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DATAZONE_API GetEnvironmentBlueprintResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of this Amazon DataZone blueprint.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetEnvironmentBlueprintResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of this Amazon DataZone blueprint.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetEnvironmentBlueprintResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of this Amazon DataZone blueprint.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetEnvironmentBlueprintResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The provider of this Amazon DataZone blueprint.</p>
   */
  inline const Aws::String& GetProvider() const { return m_provider; }
  template <typename ProviderT = Aws::String>
  void SetProvider(ProviderT&& value) {
    m_providerHasBeenSet = true;
    m_provider = std::forward<ProviderT>(value);
  }
  template <typename ProviderT = Aws::String>
  GetEnvironmentBlueprintResult& WithProvider(ProviderT&& value) {
    SetProvider(std::forward<ProviderT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The provisioning properties of this Amazon DataZone blueprint.</p>
   */
  inline const ProvisioningProperties& GetProvisioningProperties() const { return m_provisioningProperties; }
  template <typename ProvisioningPropertiesT = ProvisioningProperties>
  void SetProvisioningProperties(ProvisioningPropertiesT&& value) {
    m_provisioningPropertiesHasBeenSet = true;
    m_provisioningProperties = std::forward<ProvisioningPropertiesT>(value);
  }
  template <typename ProvisioningPropertiesT = ProvisioningProperties>
  GetEnvironmentBlueprintResult& WithProvisioningProperties(ProvisioningPropertiesT&& value) {
    SetProvisioningProperties(std::forward<ProvisioningPropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The deployment properties of this Amazon DataZone blueprint.</p>
   */
  inline const DeploymentProperties& GetDeploymentProperties() const { return m_deploymentProperties; }
  template <typename DeploymentPropertiesT = DeploymentProperties>
  void SetDeploymentProperties(DeploymentPropertiesT&& value) {
    m_deploymentPropertiesHasBeenSet = true;
    m_deploymentProperties = std::forward<DeploymentPropertiesT>(value);
  }
  template <typename DeploymentPropertiesT = DeploymentProperties>
  GetEnvironmentBlueprintResult& WithDeploymentProperties(DeploymentPropertiesT&& value) {
    SetDeploymentProperties(std::forward<DeploymentPropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user parameters of this blueprint.</p>
   */
  inline const Aws::Vector<CustomParameter>& GetUserParameters() const { return m_userParameters; }
  template <typename UserParametersT = Aws::Vector<CustomParameter>>
  void SetUserParameters(UserParametersT&& value) {
    m_userParametersHasBeenSet = true;
    m_userParameters = std::forward<UserParametersT>(value);
  }
  template <typename UserParametersT = Aws::Vector<CustomParameter>>
  GetEnvironmentBlueprintResult& WithUserParameters(UserParametersT&& value) {
    SetUserParameters(std::forward<UserParametersT>(value));
    return *this;
  }
  template <typename UserParametersT = CustomParameter>
  GetEnvironmentBlueprintResult& AddUserParameters(UserParametersT&& value) {
    m_userParametersHasBeenSet = true;
    m_userParameters.emplace_back(std::forward<UserParametersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The glossary terms attached to this Amazon DataZone blueprint.</p>
   */
  inline const Aws::Vector<Aws::String>& GetGlossaryTerms() const { return m_glossaryTerms; }
  template <typename GlossaryTermsT = Aws::Vector<Aws::String>>
  void SetGlossaryTerms(GlossaryTermsT&& value) {
    m_glossaryTermsHasBeenSet = true;
    m_glossaryTerms = std::forward<GlossaryTermsT>(value);
  }
  template <typename GlossaryTermsT = Aws::Vector<Aws::String>>
  GetEnvironmentBlueprintResult& WithGlossaryTerms(GlossaryTermsT&& value) {
    SetGlossaryTerms(std::forward<GlossaryTermsT>(value));
    return *this;
  }
  template <typename GlossaryTermsT = Aws::String>
  GetEnvironmentBlueprintResult& AddGlossaryTerms(GlossaryTermsT&& value) {
    m_glossaryTermsHasBeenSet = true;
    m_glossaryTerms.emplace_back(std::forward<GlossaryTermsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A timestamp of when this blueprint was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  GetEnvironmentBlueprintResult& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp of when this blueprint was updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdatedAt() const { return m_updatedAt; }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  void SetUpdatedAt(UpdatedAtT&& value) {
    m_updatedAtHasBeenSet = true;
    m_updatedAt = std::forward<UpdatedAtT>(value);
  }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  GetEnvironmentBlueprintResult& WithUpdatedAt(UpdatedAtT&& value) {
    SetUpdatedAt(std::forward<UpdatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetEnvironmentBlueprintResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_name;

  Aws::String m_description;

  Aws::String m_provider;

  ProvisioningProperties m_provisioningProperties;

  DeploymentProperties m_deploymentProperties;

  Aws::Vector<CustomParameter> m_userParameters;

  Aws::Vector<Aws::String> m_glossaryTerms;

  Aws::Utils::DateTime m_createdAt{};

  Aws::Utils::DateTime m_updatedAt{};

  Aws::String m_requestId;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_providerHasBeenSet = false;
  bool m_provisioningPropertiesHasBeenSet = false;
  bool m_deploymentPropertiesHasBeenSet = false;
  bool m_userParametersHasBeenSet = false;
  bool m_glossaryTermsHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_updatedAtHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataZone
}  // namespace Aws
