/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.CheckReturnValue;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.internal.InternalDocLink;
import org.jspecify.annotations.Nullable;

public abstract class Documentation
implements InternalDocLink {
    public static final String RECOMMENDATION = "For more %s, please refer to %s in the Gradle documentation.";
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();

    public static Documentation userManual(String id, String section) {
        return new UserGuide(id, section);
    }

    public static Documentation userManual(String id) {
        return new UserGuide(id, null);
    }

    public static Documentation upgradeMinorGuide(int majorVersion, String upgradeGuideSection) {
        return UpgradeGuide.forMinorVersion(majorVersion, upgradeGuideSection);
    }

    public static Documentation upgradeMajorGuide(int majorVersion, String upgradeGuideSection) {
        return UpgradeGuide.forMajorVersion(majorVersion, upgradeGuideSection);
    }

    public static Documentation dslReference(Class<?> targetClass, String property) {
        return new DslReference(targetClass, property);
    }

    public static Documentation kotlinDslExtensionReference(String extensionName) {
        return new KotlinDslExtensionReference(extensionName);
    }

    public String getConsultDocumentationMessage() {
        return String.format(RECOMMENDATION, "information", this.getUrl());
    }

    private static class UserGuide
    extends SerializableDocumentation {
        private final String page;
        private final String section;
        private final String topic;

        private UserGuide(String id, @Nullable String section) {
            this.page = (String)Preconditions.checkNotNull((Object)id);
            this.section = section;
            this.topic = null;
        }

        public String getUrl() {
            if (this.section == null) {
                return DOCUMENTATION_REGISTRY.getDocumentationFor(this.page);
            }
            if (this.topic == null) {
                return DOCUMENTATION_REGISTRY.getDocumentationFor(this.page, this.section);
            }
            return DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor(this.topic, this.page, this.section);
        }

        public boolean equals(Object o) {
            if (!(o instanceof UserGuide)) {
                return false;
            }
            UserGuide userGuide = (UserGuide)o;
            return Objects.equal((Object)this.page, (Object)userGuide.page) && Objects.equal((Object)this.section, (Object)userGuide.section) && Objects.equal((Object)this.topic, (Object)userGuide.topic);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.page, this.section, this.topic});
        }
    }

    private static class UpgradeGuide
    extends UserGuide {
        private UpgradeGuide(String basePath, String section) {
            super(basePath, section);
        }

        public static UpgradeGuide forMinorVersion(int majorVersion, String section) {
            return new UpgradeGuide("upgrading_version_" + majorVersion, section);
        }

        public static UpgradeGuide forMajorVersion(int majorVersion, String section) {
            return new UpgradeGuide("upgrading_major_version_" + majorVersion, section);
        }

        @Override
        public String getConsultDocumentationMessage() {
            return "Consult the upgrading guide for further information: " + this.getUrl();
        }
    }

    private static class DslReference
    extends SerializableDocumentation {
        private final Class<?> targetClass;
        private final String property;

        public DslReference(Class<?> targetClass, String property) {
            this.targetClass = (Class)Preconditions.checkNotNull(targetClass);
            this.property = (String)Preconditions.checkNotNull((Object)property);
        }

        public String getUrl() {
            return DOCUMENTATION_REGISTRY.getDslRefForProperty(this.targetClass, this.property);
        }

        public boolean equals(Object o) {
            if (!(o instanceof DslReference)) {
                return false;
            }
            DslReference that = (DslReference)o;
            return Objects.equal(this.targetClass, that.targetClass) && Objects.equal((Object)this.property, (Object)that.property);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.targetClass, this.property});
        }
    }

    private static class KotlinDslExtensionReference
    extends SerializableDocumentation {
        private final String extensionName;

        public KotlinDslExtensionReference(String extensionName) {
            this.extensionName = extensionName;
        }

        public String getUrl() {
            return DOCUMENTATION_REGISTRY.getKotlinDslRefForExtension(this.extensionName);
        }

        public boolean equals(Object o) {
            if (!(o instanceof KotlinDslExtensionReference)) {
                return false;
            }
            KotlinDslExtensionReference that = (KotlinDslExtensionReference)o;
            return Objects.equal((Object)this.extensionName, (Object)that.extensionName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.extensionName});
        }
    }

    public static abstract class AbstractBuilder<T> {
        public abstract T withDocumentation(@Nullable DocLink var1);

        @CheckReturnValue
        public T undocumented() {
            return this.withDocumentation(null);
        }

        @CheckReturnValue
        public T withUserManual(String documentationId, String section) {
            return this.withDocumentation((DocLink)Documentation.userManual(documentationId, section));
        }

        @CheckReturnValue
        public T withDslReference(Class<?> targetClass, String property) {
            return this.withDocumentation((DocLink)Documentation.dslReference(targetClass, property));
        }

        @CheckReturnValue
        public T withUpgradeGuideSection(int majorVersion, String upgradeGuideSection) {
            return this.withDocumentation((DocLink)Documentation.upgradeMinorGuide(majorVersion, upgradeGuideSection));
        }
    }

    private static abstract class SerializableDocumentation
    extends Documentation {
        private SerializableDocumentation() {
        }
    }
}

