﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qapps/QApps_EXPORTS.h>
#include <aws/qapps/model/AttributeFilter.h>
#include <aws/qapps/model/CardOutputSource.h>
#include <aws/qapps/model/CardType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QApps {
namespace Model {

/**
 * <p>The input shape for defining a query card in an Amazon Q App.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/QQueryCardInput">AWS
 * API Reference</a></p>
 */
class QQueryCardInput {
 public:
  AWS_QAPPS_API QQueryCardInput() = default;
  AWS_QAPPS_API QQueryCardInput(Aws::Utils::Json::JsonView jsonValue);
  AWS_QAPPS_API QQueryCardInput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QAPPS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The title or label of the query card.</p>
   */
  inline const Aws::String& GetTitle() const { return m_title; }
  inline bool TitleHasBeenSet() const { return m_titleHasBeenSet; }
  template <typename TitleT = Aws::String>
  void SetTitle(TitleT&& value) {
    m_titleHasBeenSet = true;
    m_title = std::forward<TitleT>(value);
  }
  template <typename TitleT = Aws::String>
  QQueryCardInput& WithTitle(TitleT&& value) {
    SetTitle(std::forward<TitleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the query card.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  QQueryCardInput& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the card.</p>
   */
  inline CardType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(CardType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline QQueryCardInput& WithType(CardType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The prompt or instructions displayed for the query card.</p>
   */
  inline const Aws::String& GetPrompt() const { return m_prompt; }
  inline bool PromptHasBeenSet() const { return m_promptHasBeenSet; }
  template <typename PromptT = Aws::String>
  void SetPrompt(PromptT&& value) {
    m_promptHasBeenSet = true;
    m_prompt = std::forward<PromptT>(value);
  }
  template <typename PromptT = Aws::String>
  QQueryCardInput& WithPrompt(PromptT&& value) {
    SetPrompt(std::forward<PromptT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The source or type of output to generate for the query card.</p>
   */
  inline CardOutputSource GetOutputSource() const { return m_outputSource; }
  inline bool OutputSourceHasBeenSet() const { return m_outputSourceHasBeenSet; }
  inline void SetOutputSource(CardOutputSource value) {
    m_outputSourceHasBeenSet = true;
    m_outputSource = value;
  }
  inline QQueryCardInput& WithOutputSource(CardOutputSource value) {
    SetOutputSource(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Turns on filtering of responses based on document attributes or metadata
   * fields.</p>
   */
  inline const AttributeFilter& GetAttributeFilter() const { return m_attributeFilter; }
  inline bool AttributeFilterHasBeenSet() const { return m_attributeFilterHasBeenSet; }
  template <typename AttributeFilterT = AttributeFilter>
  void SetAttributeFilter(AttributeFilterT&& value) {
    m_attributeFilterHasBeenSet = true;
    m_attributeFilter = std::forward<AttributeFilterT>(value);
  }
  template <typename AttributeFilterT = AttributeFilter>
  QQueryCardInput& WithAttributeFilter(AttributeFilterT&& value) {
    SetAttributeFilter(std::forward<AttributeFilterT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_title;
  bool m_titleHasBeenSet = false;

  Aws::String m_id;
  bool m_idHasBeenSet = false;

  CardType m_type{CardType::NOT_SET};
  bool m_typeHasBeenSet = false;

  Aws::String m_prompt;
  bool m_promptHasBeenSet = false;

  CardOutputSource m_outputSource{CardOutputSource::NOT_SET};
  bool m_outputSourceHasBeenSet = false;

  AttributeFilter m_attributeFilter;
  bool m_attributeFilterHasBeenSet = false;
};

}  // namespace Model
}  // namespace QApps
}  // namespace Aws
