/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class BridgeMethodFixer
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor,
InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private String bridgedMethodName;

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if ((programMethod.getAccessFlags() & 0x40) != 0) {
            programMethod.attributesAccept(programClass, this);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.instructionsAccept(clazz, method, this);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                if (method.getName(clazz).equals(this.bridgedMethodName)) break;
                ((ProgramMethod)method).u2accessFlags &= 0xFFFFFFBF;
            }
        }
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        this.bridgedMethodName = refConstant.getName(clazz);
    }
}

