/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dartsclone.details;

import com.hankcs.hanlp.collection.dartsclone.details.AutoIntPool;

class BitVector {
    private static final int UNIT_SIZE = 32;
    private AutoIntPool _units = new AutoIntPool();
    private int[] _ranks;
    private int _numOnes;
    private int _size;

    BitVector() {
    }

    boolean get(int id) {
        return (this._units.get(id / 32) >>> id % 32 & 1) == 1;
    }

    void set(int id, boolean bit) {
        if (bit) {
            this._units.set(id / 32, this._units.get(id / 32) | 1 << id % 32);
        }
    }

    int rank(int id) {
        int unit_id = id / 32;
        return this._ranks[unit_id] + BitVector.popCount(this._units.get(unit_id) & -1 >>> 32 - id % 32 - 1);
    }

    boolean empty() {
        return this._units.empty();
    }

    int numOnes() {
        return this._numOnes;
    }

    int size() {
        return this._size;
    }

    void append() {
        if (this._size % 32 == 0) {
            this._units.add(0);
        }
        ++this._size;
    }

    void build() {
        this._ranks = new int[this._units.size()];
        this._numOnes = 0;
        for (int i = 0; i < this._units.size(); ++i) {
            this._ranks[i] = this._numOnes;
            this._numOnes += BitVector.popCount(this._units.get(i));
        }
    }

    void clear() {
        this._units.clear();
        this._ranks = null;
    }

    private static int popCount(int unit) {
        unit = ((unit & 0xAAAAAAAA) >>> 1) + (unit & 0x55555555);
        unit = ((unit & 0xCCCCCCCC) >>> 2) + (unit & 0x33333333);
        unit = (unit >>> 4) + unit & 0xF0F0F0F;
        unit += unit >>> 8;
        unit += unit >>> 16;
        return unit & 0xFF;
    }
}

