/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SameRuleGroupFilter;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleTransformer;

public class ConsistencyPatternRuleTransformer
implements PatternRuleTransformer {
    protected final Language transformerLanguage;

    public ConsistencyPatternRuleTransformer(Language lang) {
        this.transformerLanguage = lang;
    }

    @Override
    public PatternRuleTransformer.TransformedRules apply(List<AbstractPatternRule> patternRules) {
        ArrayList<AbstractPatternRule> remaining = new ArrayList<AbstractPatternRule>();
        HashMap<String, List> toTransform = new HashMap<String, List>();
        for (AbstractPatternRule abstractPatternRule : patternRules) {
            String ruleId = abstractPatternRule.getId();
            if (ruleId.startsWith(abstractPatternRule.getLanguage().getConsistencyRulePrefix())) {
                toTransform.compute(this.getMainRuleId(ruleId), (id, rules) -> {
                    if (rules == null) {
                        return new ArrayList<AbstractPatternRule>(Collections.singletonList(abstractPatternRule));
                    }
                    rules.add(abstractPatternRule);
                    return rules;
                });
                continue;
            }
            remaining.add(abstractPatternRule);
        }
        List<Rule> transformed = toTransform.values().stream().map(group -> new ConsistencyPatternRule((List<AbstractPatternRule>)group, this.transformerLanguage)).collect(Collectors.toList());
        return new PatternRuleTransformer.TransformedRules(remaining, transformed);
    }

    private String getMainRuleId(String originalId) {
        String[] parts = originalId.split("_");
        return parts[0] + "_" + parts[1];
    }

    private String getFeature(String originalId) {
        String[] parts = originalId.split("_");
        return parts[2];
    }

    public class ConsistencyPatternRule
    extends TextLevelRule {
        protected final Language ruleLanguage;
        private final List<AbstractPatternRule> rules;

        ConsistencyPatternRule(List<AbstractPatternRule> rules, Language lang) {
            this.rules = Collections.unmodifiableList(rules);
            this.ruleLanguage = lang;
            this.setPremium(rules.stream().anyMatch(r -> r.isPremium()));
        }

        public List<AbstractPatternRule> getWrappedRules() {
            return this.rules;
        }

        @Override
        public String getId() {
            return ConsistencyPatternRuleTransformer.this.getMainRuleId(this.rules.get(0).getId());
        }

        @Override
        public String getDescription() {
            return this.rules.get(0).getDescription();
        }

        @Override
        public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
            HashMap<String, Integer> countFeatures = new HashMap<String, Integer>();
            int offsetChars = 0;
            ArrayList matches = new ArrayList();
            for (AnalyzedSentence analyzedSentence : sentences) {
                List<RuleMatch> sentenceMatches = new ArrayList<RuleMatch>();
                for (AbstractPatternRule abstractPatternRule : this.rules) {
                    RuleMatch[] ruleMatches = abstractPatternRule.match(analyzedSentence);
                    sentenceMatches.addAll(Arrays.asList(ruleMatches));
                }
                sentenceMatches = new SameRuleGroupFilter().filter(sentenceMatches);
                ArrayList<RuleMatch> adjustedSentenceMatches = new ArrayList<RuleMatch>();
                for (RuleMatch rm : sentenceMatches) {
                    rm.setSentencePosition(rm.getFromPos(), rm.getToPos());
                    int fromPos = rm.getFromPos() + offsetChars;
                    int toPos = rm.getToPos() + offsetChars;
                    rm.setOffsetPosition(fromPos, toPos);
                    adjustedSentenceMatches.add(rm);
                }
                matches.addAll(adjustedSentenceMatches);
                offsetChars += analyzedSentence.getText().length();
            }
            ArrayList<RuleMatch> resultMatches = new ArrayList<RuleMatch>();
            for (RuleMatch rm : matches) {
                String feature = ConsistencyPatternRuleTransformer.this.getFeature(rm.getRule().getId());
                countFeatures.put(feature, countFeatures.getOrDefault(feature, 0) + 1);
            }
            if (countFeatures.size() < 2) {
                return resultMatches.toArray(RuleMatch.EMPTY_ARRAY);
            }
            int n = (Integer)Collections.max(countFeatures.values());
            ArrayList<String> featuresWithMax = new ArrayList<String>();
            ArrayList<String> featuresToKeep = new ArrayList<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry entry : countFeatures.entrySet()) {
                if ((Integer)entry.getValue() == n) {
                    featuresWithMax.add((String)entry.getKey());
                    continue;
                }
                featuresToKeep.add((String)entry.getKey());
            }
            arrayList.addAll(featuresWithMax);
            if (featuresWithMax.size() > 1) {
                featuresToKeep.addAll(featuresWithMax);
            }
            for (RuleMatch rm : matches) {
                if (!featuresToKeep.contains(ConsistencyPatternRuleTransformer.this.getFeature(rm.getRule().getId()))) continue;
                resultMatches.add(this.ruleLanguage.adjustMatch(rm, arrayList));
            }
            return resultMatches.toArray(RuleMatch.EMPTY_ARRAY);
        }

        @Override
        public int minToCheckParagraph() {
            return 0;
        }

        @Override
        public boolean supportsLanguage(Language language) {
            return language.equalsConsiderVariantsIfSpecified(this.ruleLanguage);
        }
    }
}

